% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{dfac}
\alias{dfac}
\title{Descending (falling) factorial.}
\usage{
dfac(x, r, method = "product")
}
\arguments{
\item{x}{A value for which the descending factorial is to be calculated.}

\item{r}{The power \code{x} is to be raised to.}

\item{method}{The method by which the descending factorials are to be calculated. Default is \code{"product"} which uses direct arithmetic. Alternative is \code{"gamma"} which calculates the ascending factorial using the Gamma function. The alternative method might be faster but might fail because the Gamma function is not defined for negative integers (returning Inf).}
}
\value{
The descending factorial of value \code{x} raised to the \code{r}'th power.
}
\description{
Calculate the descending (or falling) factorial of a value \code{x} of order \code{r}.
}
\examples{
# To calculate the 4th descending factorial for a value (e.g., 3.14):
dfac(x = 3.14, r = 4)

# To calculate the 5th descending factorial for values 3.14, 2.72, and 0.58:
dfac(x = c(3.14, 2.72, 0.58), r = 5)
}
