% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamicWhittle_prior_and_mcmc_params.R
\name{bdp_dw_est_post_stats}
\alias{bdp_dw_est_post_stats}
\title{Calculating the estimated posterior mean, median and credible region (tv-PSD)}
\usage{
bdp_dw_est_post_stats(post_sample, rescaled_time, freq, unif_CR = FALSE)
}
\arguments{
\item{post_sample}{the posterior sample generated by \link{bdp_dw_mcmc}.}

\item{rescaled_time, freq}{numeric vectors forming a rectangular grid on which the estimated tv-PSD is evaluated.}

\item{unif_CR}{a Boolean value (default FALSE) indicating whether to calculate the uniform credible region
rescaled_time must be in \eqn{[0,1]} and freq must be in \eqn{[0,\pi]}.}
}
\value{
list containing the following fields:

   \item{tvpsd.mean,tvpsd.median}{posterior mean and pointwise posterior median (matrices of dimension length(rescaled_time) by length(freq))}
   \item{tvpsd.p05,tvpsd.p95}{90 percent pointwise credibility interval}
   \item{tvpsd.u05,tvpsd.u95}{90 percent uniform credibility interval if unif_CR = TRUE. Otherwise NA}
}
\description{
Calculating the estimated posterior mean, median and credible region (tv-PSD)
}
