% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamicWhittle_miscellanea_zigzag.R
\name{local_moving_FT_zigzag}
\alias{local_moving_FT_zigzag}
\title{Calculate the moving Fourier transform ordinates}
\usage{
local_moving_FT_zigzag(x, m, thinning_factor)
}
\arguments{
\item{x}{A numeric vector containing time series.}

\item{m}{A positive integer indicating the size of window.}

\item{thinning_factor}{Selected from {1, 2, 3}.}
}
\value{
A list containing the moving Fourier transform and corresponding time grid.
}
\description{
Calculate the moving Fourier transform ordinates
}
\examples{
set.seed(1); x <- rnorm(1500)
local_moving_FT_zigzag(x, 50, 1)
}
\references{
Y. Tang et al. (2023)
\emph{Bayesian nonparametric spectral analysis of locally stationary processes}
ArXiv preprint
<arXiv:2303.11561>
}
