% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varma.R
\name{sim_varma}
\alias{sim_varma}
\title{Simulate from a VARMA model}
\usage{
sim_varma(model, n, d, rand.gen = rmvnorm, burnin = 10000, ...)
}
\arguments{
\item{model}{A list with component \code{ar} and/or \code{ma} giving the VAR and VMA 
coefficients respectively. An empty list gives an VARMA(0, 0) model, that is white noise.}

\item{n}{sample size}

\item{d}{positive integer for the dimensionality}

\item{rand.gen}{random vector generator, function of type rand.gen(n, d, ...)}

\item{burnin}{length of burnin period (initial samples that are discarded)}

\item{...}{further arguments to be parsed to \code{rand.gen}}
}
\value{
If n=1 a vector of length d, otherwise an n by d matrix with one sample in each row.
}
\description{
Simulate from a Vector Autoregressive Moving Average (VARMA) model.
Note that no test for model stationarity is performed.
}
\examples{
\dontrun{
# Example: Draw from bivariate normal VAR(2) model
ar <- rbind(c(.5, 0, 0, 0), c(0, -.3, 0, -.5))
Sigma <- matrix(data=c(1, .9, .9, 1), nrow=2, ncol=2)
x <- sim_varma(n=256, d=2, model=list(ar=ar))
plot.ts(x)
}
}
\seealso{
\link[stats]{arima.sim} to simulate from univariate ARMA models
}
