% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbf01.R
\name{tbf01}
\alias{tbf01}
\title{t-test Bayes factor}
\usage{
tbf01(
  t,
  n,
  n1 = n,
  n2 = n,
  plocation = 0,
  pscale = 1/sqrt(2),
  pdf = 1,
  type = c("two.sample", "one.sample", "paired"),
  alternative = c("two.sided", "less", "greater"),
  log = FALSE,
  ...
)
}
\arguments{
\item{t}{\eqn{t}-statistic}

\item{n}{Sample size (per group)}

\item{n1}{Sample size in group 1 (only required for two-sample \eqn{t}-test
with unequal group sizes)}

\item{n2}{Sample size in group 2 (only required for two-sample \eqn{t}-test
with unequal group sizes)}

\item{plocation}{\eqn{t} prior location. Defaults to \code{0}}

\item{pscale}{\eqn{t} prior scale. Defaults to \code{1/sqrt(2)}}

\item{pdf}{\eqn{t} prior degrees of freedom. Defaults to \code{1} (a Cauchy
prior)}

\item{type}{Type of \eqn{t}-test. Can be \code{"two.sample"} (default),
\code{"one.sample"}, or \code{"paired"}}

\item{alternative}{Direction of the test. Can be either \code{"two.sided"}
(default), \code{"less"}, or \code{"greater"}. The latter two truncate
the analysis prior to negative and positive effects, respectively.}

\item{log}{Logical indicating whether the natural logarithm of the Bayes
factor should be returned. Defaults to \code{FALSE}}

\item{...}{Additional arguments passed to \code{stats::integrate}}
}
\value{
Bayes factor in favor of the null hypothesis over the alternative (BF
    > 1 indicates evidence for the null hypothesis, whereas BF < 1 indicates
    evidence for the alternative)
}
\description{
This function computes the Bayes factor that forms the basis of
the informed Bayesian \eqn{t}-test from Gronau et al. (2020). The Bayes
factor quantifies the evidence that the data provide for the null
hypothesis that the standardized mean difference (SMD) is zero against
the alternative that the SMD is non-zero. A location-scale
\eqn{t}-distribution is assumed for the SMD under the alternative
hypothesis. The Jeffreys-Zellner-Siow (JZS) Bayes factor (Rouder et al.,
2009) is obtained as a special case by setting the location of the prior
to zero and the prior degrees of freedom to one, which is the default.

The data are summarized by \eqn{t}-statistics and sample sizes. The
following types of \eqn{t}-statistics are accepted:
\itemize{
\item Two-sample \eqn{t}-test where the SMD represents the standardized
mean difference between two group means (assuming equal variances in
both groups)
\item One-sample \eqn{t}-test where the SMD represents the standardized
mean difference to the null value
\item Paired \eqn{t}-test where the SMD represents the standardized mean
change score
}
}
\details{
The Bayes factor is implemented as in equation (5) in Gronau et al.
(2020), and using suitable truncation in case of one-sided alternatives.
Integration is performed numerically with \code{stats::integrate}.
}
\examples{
## analyses from Rouder et al. (2009):
## values from Table 1
tbf01(t = c(0.69, 3.20), n = 100, pscale = 1, type = "one.sample")
## examples from p. 232
tbf01(t = c(2.24, 2.03), n = 80, pscale = 1, type = "one.sample")

## analyses from Gronau et al. (2020) section 3.2:
## informed prior
tbf01(t = -0.90, n1 = 53, n2 = 57, plocation = 0.350, pscale = 0.102, pdf = 3,
      alternative = "greater", type = "two.sample")
## default (one-sided) prior
tbf01(t = -0.90, n1 = 53, n2 = 57, plocation = 0, pscale = 1/sqrt(2), pdf = 1,
      alternative = "greater", type = "two.sample")

}
\references{
Rouder, J. N., Speckman, P. L., Sun, D., Morey, R. D., Iverson,
G. (2009). Bayesian \eqn{t} tests for accepting and rejecting the null
hypothesis. Psychonomic Bulletin & Review, 16(2):225-237.
\doi{10.3758/PBR.16.2.225}

Gronau, Q. F., Ly., A., Wagenmakers, E.J. (2020). Informed Bayesian
\eqn{t}-Tests. The American Statistician, 74(2):137-143.
\doi{10.1080/00031305.2018.1562983}
}
\seealso{
\link{powertbf01}, \link{ptbf01}, \link{ntbf01}
}
\author{
Samuel Pawel
}
