% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bggAPI.R
\name{bggAPI}
\alias{bggAPI}
\title{Interface for BoardGameGeek's XML API2}
\description{
This is a class that works as a main interface to
  BoardGameGeek's API. All other \code{bgg*} classes inherit from
  \code{bggAPI}. Furthermore, there is no initialization method for
  \code{bggAPI} as it serves just as a super class for other classes.
}
\references{
\href{https://boardgamegeek.com/wiki/page/BGG_XML_API2}{BoardGameGeek XML
  API2}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{ids}}{Numeric vector of positive integers. Contains IDs of all
BoardGameGeek items that were requested and are present in
\code{data}. The vector is sorted by default.}

\item{\code{data}}{Data.table with currently fetched variables from the
object's XML. It has a row count equal to the length of \code{ids}.
Note that the copy is returned, so no modification of \code{data}
is possible outside of class methods.}

\item{\code{xml}}{An XML nodeset obtained through the BoardGameGeek's API.
It's length is equal to the length of \code{ids}.}

\item{\code{api_url}}{A character vector of one or more strings with URLs
used to fetch XMLs.}

\item{\code{params}}{A list with object parameters.}

\item{\code{timestamp}}{The date (with time) of the object creation and,
what follows, the last moment that the data was certainly up to
date.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-bggAPI-fetch}{\code{bggAPI$fetch()}}
\item \href{#method-bggAPI-expand}{\code{bggAPI$expand()}}
\item \href{#method-bggAPI-switch_namestyle}{\code{bggAPI$switch_namestyle()}}
\item \href{#method-bggAPI-clone}{\code{bggAPI$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bggAPI-fetch"></a>}}
\if{latex}{\out{\hypertarget{method-bggAPI-fetch}{}}}
\subsection{Method \code{fetch()}}{
Fetches variables with given \code{variable_names} from the
  object's \code{xml}. Returns them as a list. This is a main method of
  getting non-scalar variables (as they are hard to fit into a
  data.table).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{bggAPI$fetch(variable_names = NULL, compress = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{variable_names}}{a character vector with names of variables to
fetch.}

\item{\code{compress}}{a logical value, decides whether the fetched variables
should be compress into a scalar form (if possible).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bggAPI-expand"></a>}}
\if{latex}{\out{\hypertarget{method-bggAPI-expand}{}}}
\subsection{Method \code{expand()}}{
Expands the \code{data} table by given \code{variable_names}
  by reference. For the list of available variables for every object
  check the \code{\link{bgg_variables}} dataset.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{bggAPI$expand(variable_names = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{variable_names}}{a character vector with names of variables to add
to \code{data}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bggAPI-switch_namestyle"></a>}}
\if{latex}{\out{\hypertarget{method-bggAPI-switch_namestyle}{}}}
\subsection{Method \code{switch_namestyle()}}{
Switches between two styles of naming the variables:
  \code{'classic'} and \code{'pretty'}. The former is a default value and
  uses code names concordant with BoardGameGeek's naming convention in
  the XMLs. The latter is more intuitive and uses UpperCamelCase.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{bggAPI$switch_namestyle(to)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{to}}{a single string, either \code{'classic'} or \code{'pretty'}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns \code{TRUE} or \code{FALSE} invisibly depending on
  whether the names have been switched.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bggAPI-clone"></a>}}
\if{latex}{\out{\hypertarget{method-bggAPI-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{bggAPI$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
