% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlebgumbel.R
\name{mlebgumbel}
\alias{mlebgumbel}
\title{Bimodal Gumbel: Maximum Likelihood Estimation}
\usage{
mlebgumbel(data, theta)
}
\arguments{
\item{data}{A numeric vector.}

\item{theta}{Vector. Starting parameter values for the minimization. Default: theta = c(1, 1, 1)}
}
\value{
List.
}
\description{
Bimodal Gumbel: Maximum Likelihood Estimation
}
\examples{
# Let's generate some values

set.seed(123)
x <- rbgumbel(1000, mu = -2, sigma = 1, delta = -1)

# Look for these references in the figure:

hist(x, probability = TRUE)
lines(density(x), col = 'blue')
abline(v = c(-2.5, -.5), col = 'red')
text(x = c(c(-2.5, -.5)), y = c(.05, .05), c('mu\nnear here', 'delta\nnear here'))

# Time to fit!

fit <- mlebgumbel(
   data = x,
   theta = c(-3, 2, -2) # try some values near the region. Format: theta = c(mu, sigma, delta)
)
print(fit)

\donttest{
# Kolmogorov-Smirnov Tests

mu.sigma.delta <- fit$estimate$estimate
ks.test(
  x,
  y = 'pbgumbel',
  mu = mu.sigma.delta[[1]],
  sigma = mu.sigma.delta[[2]],
  delta = mu.sigma.delta[[3]]
)
}
}
