% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Misc.R
\name{scaleRoundList}
\alias{scaleRoundList}
\title{scaleRoundList}
\usage{
scaleRoundList(list, scale_param = 1, round_digits = NULL)
}
\arguments{
\item{list}{The list to which the scaling and rounding should be applied to.}

\item{scale_param}{A numeric for the scaling of each item of the list, Default: `1`}

\item{round_digits}{An integer for the number of digits.
If `NULL`, no rounding will be applied, Default: `NULL`}
}
\value{
A list of scaled and rounded numerics
}
\description{
This function applies scaling and rounding to each item of a list of numerics
}
\examples{
some_list <- as.list(runif(5))
scaleRoundList(some_list, scale_param = 100, round_digits = 2)

scenarios_list <- simulateScenarios(
  n_subjects_list     = list(c(10, 20, 30)),
  response_rates_list = list(c(0.1, 0.2, 0.3)),
  n_trials            = 10)

analyses_list <- performAnalyses(
  scenario_list       = scenarios_list,
  target_rates        = rep(0.5, 3),
  n_mcmc_iterations   = 100,
  n_cores             = 1L)

scaleRoundList(
  list         = getEstimates(analyses_list),
  scale_param  = 100,
  round_digits = 2)
}
\author{
Stephan Wojciekowski
}
