% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thematicMap.R
\name{thematicMap}
\alias{thematicMap}
\title{Create a thematic map}
\usage{
thematicMap(Net, NetMatrix, S = NULL, minfreq = 5)
}
\arguments{
\item{Net}{is a igraph object created by \code{\link{networkPlot}} function.}

\item{NetMatrix}{is a co-occurence matrix obtained by the network functions 
\code{\link{biblioNetwork}} or \code{\link{cocMatrix}}.}

\item{S}{is a similarity matrix obtained by the \code{\link{normalizeSimilarity}} function. 
If S is NULL, map is created using co-occurrence counts.}

\item{minfreq}{is a integer. It indicates the minimun frequency of a cluster.}
}
\value{
a list containing:
\tabular{lll}{
\code{map}\tab   \tab The thematic map as ggplot2 object\cr
\code{clusters}\tab   \tab Centrality and Density values for each cluster. \cr
\code{words}\tab   \tab A list of words following in each cluster}
}
\description{
It creates a thematic map based on co-word network analysis and clustering.
The methodology is inspired by the proposal of Cobo et al. (2011).
}
\details{
\code{thematicMap} starts from a co-occurrence keyword network to plot in a 
two-dimesional map the typological themes of a domain.
}
\examples{

data(scientometrics)
NetMatrix <- biblioNetwork(scientometrics, analysis = "co-occurrences", 
              network = "keywords", sep = ";")
S <- normalizeSimilarity(NetMatrix, type = "association")
net <- networkPlot(S, n = 100, Title = "co-occurrence network",type="fruchterman",
     labelsize = 0.7, halo = FALSE, cluster = "walktrap",remove.isolates=FALSE,
     remove.multiple=FALSE, noloops=TRUE, weighted=TRUE)
res <- thematicMap(net, NetMatrix, S)
plot(res$map)

}
\seealso{
\code{\link{biblioNetwork}} function to compute a bibliographic network.

\code{\link{cocMatrix}} to compute a bibliographic bipartite network.

\code{\link{networkPlot}} to plot a bibliographic network.
}
