% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfa.tree.gen.R
\name{bfa.tree.gen}
\alias{bfa.tree.gen}
\title{Bifurcating Autoregressive Tree generator}
\usage{
bfa.tree.gen(n, p, s1, s2, r1, r2, g, intercept, ar.coef)
}
\arguments{
\item{n}{tree size (integer)}

\item{p}{an integer determining the order of bifurcating autoregressive model}

\item{s1}{standard deviation of the errors distribution}

\item{s2}{standard deviation of the second component of the mixture normal
distribution generating contaminated errors. s2 should be greater than s1.
s2 is only effective when g>0.}

\item{r1}{correlation between pairs of errors}

\item{r2}{is used in combination with \code{r1} to compute the correlation
between pairs of errors in the second component of the mixture normal
distribution generating the contaminated errors. r2 is only effective when
g>0.}

\item{g}{proportion of contamination. Defaults to zero producing
non-contaminated multivariate normal errors for the tree generation.}

\item{intercept}{the intercept in the BAR model generating the tree}

\item{ar.coef}{a vector of length p giving the autoregressive coefficients in
the BAR model generating the tree}
}
\value{
A numeric vector representing a bifurcating autoregressive (BFA) tree
with \code{n} observations.
}
\description{
This function generate bifurcating autoregressive (BFA) trees of any size
based on a BFA model of any order.
}
\examples{
#Non-contaminted BAR(1) tree:
bfa.tree.gen(127, 1, 1, 1, 0.5, 0.5, 0, 10, c(0.7))
#Non-contaminted BAR(2) tree:
bfa.tree.gen(127, 2, 1, 1, 0.5, 0.5, 0, 10, c(0.5, 0.3))
#Contaminted BAR(1) tree:
bfa.tree.gen(127, 1, 1, 2, 0.5, 0.5, 0.2, 10, c(0.7))
}
