% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmnorm.R
\name{rmnorm}
\alias{rmnorm}
\title{Multivariate Normal Generator}
\usage{
rmnorm(n, d = 2, mu = rep(0, d), sigma = diag(d))
}
\arguments{
\item{n}{sample size}

\item{d}{dimension. Defaults to 2 for bivariate normal errors.}

\item{mu}{mean vector. Defaults to the zero vector.}

\item{sigma}{variance-covariance matrix. Defaults to the \code{d} by \code{d}
identity matrix, where d is the dimension.}
}
\value{
An \code{n} by \code{d} multivariate normal matrix.
}
\description{
This function generates multivariate normal errors that are used in the
generation of the Bifurcating autoregressive tree.
}
\examples{
rmnorm(10)
rmnorm(10, 3)
}
