% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdf_ftf.R
\docType{data}
\name{flex_t12_lst}
\alias{flex_t12_lst}
\title{A list of all 12-hour flexible time types}
\format{
An object of class \code{list} of length 12.
}
\usage{
flex_t12_lst
}
\value{
A list where each element corresponds to a classifier for a 12-hour
flexible time type.
}
\description{
The \code{flex_t12_lst} object is a list of the 12-hour flexible time types which
are widely supported. Flexible time types are classes of time formatting
which can be translated across locales. There are 12
flexible time types of the 12-hour variety in \code{flex_t12_lst}.
}
\section{Examples}{


The \code{flex_t12_lst} object can be incredibly useful when you need to get a
format for 12-hour time formatting that works across all locales. You can
avoid typing errors by using this list and every flexible time type from this
list is guaranteed to work across all supported locales. In this example,
we'll use the \code{"Ehms"} flexible time type by accessing it from the
\code{flex_t12_lst} object.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fdt(
  input = "2018-07-04 22:05",
  format = flex_t12_lst$Bhms,
  locale = "en"
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "10:05:00 at night"
}\if{html}{\out{</div>}}

If we wanted this in a different locale, the locale-specific \code{format} pattern
behind the flexible date identifier would ensure consistency while moving to
that locale. Let's use the \code{fdt_locales_lst} object in the same spirit to
specify the German (Austria) locale.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fdt(
  input = "2018-07-04 22:05",
  format = flex_t12_lst$Bhms,
  locale = fdt_locales_lst$de_AT
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "10:05:00 abends"
}\if{html}{\out{</div>}}
}

\keyword{datasets}
