% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigKRLS.R
\name{summary.bigKRLS}
\alias{summary.bigKRLS}
\title{summary.bigKRLS}
\usage{
\method{summary}{bigKRLS}(object, degrees = "Neffective",
  probs = c(0.05, 0.25, 0.5, 0.75, 0.95), digits = 4, labs = NULL,
  ...)
}
\arguments{
\item{object}{bigKRLS output.}

\item{degrees}{"Neffective" (default) or "N". If "Neffective" (default), degrees of freedom for t tests reflects degrees of freedom used to obtain regularization parameter, lambda. Neffective = N - sum(eigenvalues/(eigenvalues + lambda)); see e.g. Hastie et al. (2015, 61-68). 'N' is simply the observed sample size (note this is the default for library(KRLS)). Degrees of freedom for t-tests is either Neffective - P or N - P.}

\item{probs}{Which quantiles of the marginal effects of each x variable should be displayed?}

\item{digits}{Number of signficant digits.}

\item{labs}{Optional vector of x labels.}

\item{...}{ignore}
}
\value{
Returns list with "ttests" (Average Marginal Effect estimates, standard errors, t-values, and p values) and "percentiles" (of the marginal effects).
}
\description{
Summary function for bigKRLS output.
}
\examples{
# y <- as.matrix(ChickWeight$weight)
# X <- matrix(cbind(ChickWeight$Time, ChickWeight$Diet == 1), ncol = 2)

# out <- bigKRLS(y, X, Ncores=1)
# summary(out)

# s = summary(out, digits = 2, labs = c("Time", "ChickWeightDiet"))

# knitr::kable(s[["ttests"]])     # to format with RNotebook or RMarkdown
# knitr::kable(s[["percentiles"]])

# Calcuate p-values using uncorrected standard errors (not recommended)
# summary(out, degrees = "N")
}
