% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.cv.R
\name{predict.cv.biglasso}
\alias{predict.cv.biglasso}
\alias{coef.cv.biglasso}
\title{Model predictions based on a fitted \code{\link{cv.biglasso}} object}
\usage{
\method{predict}{cv.biglasso}(object, X, row.idx = 1:nrow(X),
  type = c("link", "response", "class", "coefficients", "vars", "nvars"),
  lambda = object$lambda.min, which = object$min, ...)

\method{coef}{cv.biglasso}(object, lambda = object$lambda.min,
  which = object$min, ...)
}
\arguments{
\item{object}{A fitted \code{"cv.biglasso"} model object.}

\item{X}{Matrix of values at which predictions are to be made. It must be a
\code{\link[bigmemory]{big.matrix}} object. Not used for
\code{type="coefficients"}.}

\item{row.idx}{Similar to that in \code{\link[biglasso]{biglasso}}, it's a
vector of the row indices of \code{X} that used for the prediction.
\code{1:nrow(X)} by default.}

\item{type}{Type of prediction: \code{"link"} returns the linear predictors;
\code{"response"} gives the fitted values; \code{"class"} returns the
binomial outcome with the highest probability; \code{"coefficients"} returns
the coefficients; \code{"vars"} returns a list containing the indices and
names of the nonzero variables at each value of \code{lambda};
\code{"nvars"} returns the number of nonzero coefficients at each value of
\code{lambda}.}

\item{lambda}{Values of the regularization parameter \code{lambda} at which
predictions are requested.  The default value is the one corresponding to
the minimum cross-validation error.}

\item{which}{Indices of the penalty parameter \code{lambda} at which
predictions are requested. The default value is the index of lambda
corresponding to lambda.min.  Note: this is overridden if \code{lambda} is
specified.}

\item{\dots}{Not used.}
}
\value{
The object returned depends on \code{type}.
}
\description{
Extract predictions from a fitted \code{\link{cv.biglasso}} object.
}
\examples{
\dontrun{
## predict.cv.biglasso
data(colon)
X <- colon$X
y <- colon$y
X.bm <- as.big.matrix(X, backingfile = "")
fit <- biglasso(X.bm, y, penalty = 'lasso', family = "binomial")
cvfit <- cv.biglasso(X.bm, y, penalty = 'lasso', family = "binomial", seed = 1234, ncores = 2)
coef <- coef(cvfit)
coef[which(coef != 0)]
predict(cvfit, X.bm, type = "response")
predict(cvfit, X.bm, type = "link")
predict(cvfit, X.bm, type = "class")
}
}
\seealso{
\code{\link{biglasso}}, \code{\link{cv.biglasso}}
}
\author{
Yaohui Zeng and Patrick Breheny

Maintainer: Yaohui Zeng <yaohui.zeng@gmail.com>
}
\keyword{models}
\keyword{regression}
