% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unit_conversions.r
\name{ms.to.mol}
\alias{ms.to.mol}
\alias{mol.to.ms}
\alias{mol.to.ms}
\title{Conversion between Conductance Units}
\usage{
ms.to.mol(G_ms, Tair, pressure, constants = bigleaf.constants())

mol.to.ms(G_mol, Tair, pressure, constants = bigleaf.constants())
}
\arguments{
\item{G_ms}{Conductance (m s-1)}

\item{Tair}{Air temperature (deg C)}

\item{pressure}{Atmospheric pressure (kPa)}

\item{constants}{Kelvin - conversion degree Celsius to Kelvin \cr
Rgas - universal gas constant (J mol-1 K-1) \cr
kPa2Pa - conversion kilopascal (kPa) to pascal (Pa)}

\item{G_mol}{Conductance (mol m-2 s-1)}
}
\description{
Converts conductances from mass (m s-1)
             to molar units (mol m-2 s-1), or vice versa.
}
\details{
The conversions are given by:

\deqn{G_mol = G_ms * pressure / (Rgas * Tair)}

\deqn{G_ms = G_mol * (Rgas * Tair) / pressure}

where Tair is in Kelvin and pressure in Pa (converted from kPa internally)
}
\examples{
ms.to.mol(0.005,25,100)
            
}
\references{
Jones, H.G. 1992. Plants and microclimate: a quantitative approach to environmental plant physiology.
            2nd Edition., Cambridge University Press, Cambridge. 428 p
}
