% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energy_balance.r
\name{energy.closure}
\alias{energy.closure}
\title{Energy Balance Closure}
\usage{
energy.closure(
  data,
  Rn = "Rn",
  G = NULL,
  S = NULL,
  LE = "LE",
  H = "H",
  instantaneous = FALSE,
  missing.G.as.NA = FALSE,
  missing.S.as.NA = FALSE
)
}
\arguments{
\item{data}{Data.frame or matrix containing all required variables.}

\item{Rn}{Net radiation (W m-2)}

\item{G}{Ground heat flux (W m-2); optional}

\item{S}{Sum of all storage fluxes (W m-2); optional}

\item{LE}{Latent heat flux (W m-2)}

\item{H}{Sensible heat flux (W m-2)}

\item{instantaneous}{should the energy balance be calculated at the time step 
of the observations (\code{TRUE}), or over the entire time period
provided as input (\code{FALSE})}

\item{missing.G.as.NA}{if \code{TRUE}, missing G are treated as \code{NA}s ,otherwise set to 0.}

\item{missing.S.as.NA}{if \code{TRUE}, missing S are treated as \code{NA}s, otherwise set to 0.}
}
\value{
a named vector containing:
        \item{n}{number of complete (all energy balance terms available) observations}
        \item{intercept}{intercept of the OLS regression}
        \item{slope}{slope of the OLS regression}
        \item{r_squared}{r^2 of the OLS regression}
        \item{EBR}{energy balance ratio}
        
        if \code{instantaneous = TRUE}, only \code{EBR} is returned.
}
\description{
Calculates the degree of the energy balance non-closure for the entire time span
             based on the ratio of two sums (energy balance ratio), and ordinary least squares (OLS).
}
\details{
The energy balance ratio (EBR) is calculated as:
         
           \deqn{EBR = sum(LE + H)/sum(Rn - G - S)}
         
         the sum is taken for all time steps with complete observations (i.e. where
         all energy balance terms are available).
}
\examples{
## characterize energy balance closure for DE-Tha in June 2014
energy.closure(DE_Tha_Jun_2014,instantaneous=FALSE)

## look at half-hourly closure 
EBR_inst <- energy.closure(DE_Tha_Jun_2014,instantaneous=TRUE)
summary(EBR_inst)

}
\references{
Wilson K., et al. 2002: Energy balance closure at FLUXNET sites.
            Agricultural and Forest Meteorology 113, 223-243.
}
