% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigmemory.R
\docType{class}
\name{descriptor-class}
\alias{attach.resource,big.matrix.descriptor-method}
\alias{attach.resource,character-method}
\alias{big.matrix.descriptor-class}
\alias{descriptor-class}
\alias{sub.big.matrix,big.matrix.descriptor-method}
\title{Class "big.matrix.descriptor"}
\usage{
\S4method{sub.big.matrix}{big.matrix.descriptor}(x, firstRow = 1,
  lastRow = NULL, firstCol = 1, lastCol = NULL, backingpath = NULL)

\S4method{attach.resource}{character}(obj, ...)

\S4method{attach.resource}{big.matrix.descriptor}(obj, ...)
}
\arguments{
\item{x}{A descriptor object}

\item{firstRow}{the first row of the submatrix}

\item{lastRow}{the last row of the submatrix if not NULL}

\item{firstCol}{the first column of the submatrix}

\item{lastCol}{of the submatrix if not NULL}

\item{backingpath}{required path to the filebacked object, if applicable}

\item{obj}{The filename of the descriptor for a filebacked matrix,
assumed ot be in the directory specified}

\item{...}{possibly \code{path} which gives the path where the descriptor
and/or filebacking can be found.}
}
\description{
An object of this class contains necessary and sufficient information
to ``attach'' a shared or filebacked \code{\link{big.matrix}}.
}
\note{
We provide \code{attach.resource} for convenience, but expect most users
will prefer \code{\link{attach.big.matrix}}.
}
\section{Objects from the Class}{

Objects should not be created by calls of the form \code{new("big.matrix.descriptor", ...)},
but should use the \code{\link{describe}} function.
}

\section{Slots}{

  \describe{
     \item{\code{description}:}{Object of class \code{"list"}; details omitted.}
  }
}

\section{Extends}{

Class \code{"\linkS4class{descriptor}"}, directly.
}

\section{Methods}{

\describe{
     \item{attach.resource}{\code{signature(obj = "big.matrix.descriptor")}: ... }
     \item{sub.big.matrix}{\code{signature(x = "big.matrix.descriptor")}: ... }
 }
}
\examples{
showClass("big.matrix.descriptor")
}
\author{
John W. Emerson and Michael J. Kane
}
\references{
Other types of descriptors are defined in package \pkg{synchronicity}.
}
\seealso{
See also \code{\link{attach.big.matrix}}.
}
\keyword{classes}

