\name{scaling-methods}
\docType{methods}
\alias{scaling}
\alias{scaling-methods}
\alias{scaling,bigrfprox-method}
\title{Compute Metric Scaling Co-ordinates}
\description{
  Compute metric scaling co-ordinates for training examples in a random forest, based on the proximity matrix generated by \code{\link[bigrf]{proximities}}. Scaling co-ordinates are useful for visualising the data.
}
\usage{
\S4method{scaling}{bigrfprox}(prox, nscale=2L, trace=0L)
}
\arguments{
  \item{prox}{A proximity matrix of class \code{"\linkS4class{bigrfprox}"}.}
  \item{nscale}{The number of scaling co-ordinates to compute. Typically, the first two or three scaling co-ordinates are the most useful. Default: \code{2L}.}
  \item{trace}{\code{0} for no verbose output. \code{1} to print verbose output. \code{2} to print even more verbose output on the progress of finding scaling coordinates. Default: \code{0}.}
}
\value{
  A \code{matrix} containing the scaling co-ordinates for each example, where the \code{i}th column contains the \code{i}th scaling co-ordinates.
}
\section{Methods}{
  \describe{
    \item{\code{signature(prox = "bigrfprox")}}{Compute metric scaling coordinates for a random forest.}
  }
}
\references{
  Breiman, L. (2001). Random forests. \emph{Machine learning}, \bold{45(1)}, 5-32.

  Breiman, L. & Cutler, A. (n.d.). Random Forests. Retrieved from \url{http://www.stat.berkeley.edu/~breiman/RandomForests/cc_home.htm}.
}
\examples{
# Classify cars in the Cars93 data set by type (Compact, Large,
# Midsize, Small, Sporty, or Van).

# Load data.
data(Cars93, package="MASS")
x <- Cars93
y <- Cars93$Type

# Select variables with which to train model.
vars <- c(4:22)

# Run model, grow 50 trees.
forest <- bigrfc(x, y, ntree=50L, varselect=vars, cachepath=NULL)

# Calculate proximity matrix.
prox <- proximities(forest, cachepath=NULL)

# Calculate scaling co-ordinates.
scale <- scaling(prox, 3L)

# Plot the 1st vs 2nd scaling co-ordinates.
plot(scale[, 1], scale[, 2], col=as.integer(y), pch=as.integer(y))

# Plot the 1st vs 3rd scaling co-ordinates.
plot(scale[, 1], scale[, 3], col=as.integer(y), pch=as.integer(y))

# Plot the 2nd vs 3rd scaling co-ordinates.
plot(scale[, 2], scale[, 3], col=as.integer(y), pch=as.integer(y))
}
\keyword{methods}
