% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old-tabledata.R
\name{list_tabledata}
\alias{list_tabledata}
\alias{list_tabledata_callback}
\alias{list_tabledata_iter}
\title{Retrieve data from a table \link{deprecated}}
\usage{
list_tabledata(project, dataset, table, page_size = 10000,
  table_info = NULL, max_pages = 10, warn = TRUE,
  quiet = getOption("bigrquery.quiet"))

list_tabledata_callback(project, dataset, table, callback, table_info = NULL,
  page_size = getOption("bigrquery.page.size"), max_pages = 10,
  warn = TRUE, quiet = getOption("bigrquery.quiet"))

list_tabledata_iter(project, dataset, table, table_info = NULL)
}
\arguments{
\item{page_size}{Number of items per page.}

\item{table_info}{if known, the table information retrieved with
\code{\link[=get_table]{get_table()}}}

\item{max_pages}{maximum number of pages to retrieve. Use \code{Inf}
to retrieve the complete dataset.}

\item{warn}{If \code{TRUE}, warn when there are rows remaining to
be pulled down from database.}

\item{quiet}{if \code{FALSE}, prints informative status messages.}

\item{callback}{function called with single argument, the data from the
current page of data}
}
\value{
\code{list_tabledata} returns a single dataframe.

\code{list_tabledata_iter} returns a named list with functions
\itemize{
\item \code{next_} (fetches one chunk of rows)
\item \code{next_paged} (fetches arbitrarily many rows using a specified page size)
\item \code{is_complete} (checks if all rows have been fetched)
\item \code{get_schema} (returns the schema of the table),
\item \code{get_rows_fetched} (returns the number of rows already fetched).
\item \code{get_rows} (returns total number of rows)
}
}
\description{
Please use \link{bq_table_download} instead.

\code{list_tabledata_callback} calls the supplied callback with each page
of data.
}
\examples{
\dontrun{
billing_project <- "341409650721" # put your project number here
natal <- list_tabledata("publicdata", "samples", "natality", max_pages = 2,
  page_size = 10)
dim(natal)
}
}
\seealso{
API documentation at
\url{https://developers.google.com/bigquery/docs/reference/v2/tabledata/list}
}
\keyword{internal}
