% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old-query.R
\name{query_exec}
\alias{query_exec}
\title{Run a asynchronous query and retrieve results \link{deprecated}}
\usage{
query_exec(
  query,
  project,
  destination_table = NULL,
  default_dataset = NULL,
  page_size = 10000,
  max_pages = 10,
  warn = TRUE,
  create_disposition = "CREATE_IF_NEEDED",
  write_disposition = "WRITE_EMPTY",
  use_legacy_sql = TRUE,
  quiet = getOption("bigrquery.quiet"),
  ...
)
}
\arguments{
\item{query}{SQL query string}

\item{destination_table}{(optional) destination table for large queries,
either as a string in the format used by BigQuery, or as a list with
\code{project_id}, \code{dataset_id}, and \code{table_id} entries}

\item{default_dataset}{(optional) default dataset for any table references in
\code{query}, either as a string in the format used by BigQuery or as a
list with \code{project_id} and \code{dataset_id} entries}

\item{page_size}{Number of items per page.}

\item{max_pages}{Maximum number of pages to retrieve. Use \code{Inf} to retrieve
all pages (this may take a long time!)}

\item{warn}{If \code{TRUE}, warn when there are unretrieved pages.}

\item{create_disposition}{behavior for table creation.
defaults to \code{"CREATE_IF_NEEDED"},
the only other supported value is \code{"CREATE_NEVER"}; see
\href{https://cloud.google.com/bigquery/docs/reference/v2/jobs#configuration.query.createDisposition}{the API documentation}
for more information}

\item{write_disposition}{behavior for writing data.
defaults to \code{"WRITE_EMPTY"}, other possible values are
\code{"WRITE_TRUNCATE"} and \code{"WRITE_APPEND"}; see
\href{https://cloud.google.com/bigquery/docs/reference/v2/jobs#configuration.query.writeDisposition}{the API documentation}
for more information}

\item{use_legacy_sql}{(optional) set to \code{FALSE} to enable BigQuery's standard SQL.}

\item{...}{Additional arguments passed on to the underlying API call.
snake_case names are automatically converted to camelCase.}
}
\description{
Please use \code{\link[=bq_project_query]{bq_project_query()}} instead.
}
\examples{
\dontrun{
project <- bq_test_project() # put your project ID here
sql <- "SELECT year, month, day, weight_pounds FROM [publicdata:samples.natality] LIMIT 5"
query_exec(sql, project = project)
# Put the results in a table you own (which uses project by default)
query_exec(sql, project = project, destination_table = "my_dataset.results")
# Use a default dataset for the query
sql <- "SELECT year, month, day, weight_pounds FROM natality LIMIT 5"
query_exec(sql, project = project, default_dataset = "publicdata:samples")
}
}
\seealso{
Google documentation describing asynchronous queries:
\url{https://developers.google.com/bigquery/docs/queries#asyncqueries}

Google documentation for handling large results:
\url{https://developers.google.com/bigquery/querying-data#largequeryresults}
}
\keyword{internal}
