% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult-mat.R
\name{big_prodMat}
\alias{big_prodMat}
\alias{\%*\%,FBM,matrix-method}
\alias{\%*\%,matrix,FBM-method}
\title{Product with a matrix}
\usage{
big_prodMat(
  X,
  A.col,
  ind.row = rows_along(X),
  ind.col = cols_along(X),
  ncores = 1,
  block.size = block_size(nrow(X), ncores),
  center = NULL,
  scale = NULL
)

\S4method{\%*\%}{FBM,matrix}(x, y)

\S4method{\%*\%}{matrix,FBM}(x, y)
}
\arguments{
\item{X}{An object of class \link[=FBM-class]{FBM}.}

\item{A.col}{A matrix with \code{length(ind.col)} rows.}

\item{ind.row}{An optional vector of the row indices that are used.
If not specified, all rows are used. \strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices that are used.
If not specified, all columns are used. \strong{Don't use negative indices.}}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}

\item{block.size}{Maximum number of columns read at once.
Default uses \link{block_size}.}

\item{center}{Vector of same length of \code{ind.col} to subtract from columns
of \code{X}.}

\item{scale}{Vector of same length of \code{ind.col} to divide from columns
of \code{X}.}

\item{x}{A 'double' FBM or a matrix.}

\item{y}{A 'double' FBM or a matrix.}
}
\value{
\eqn{X \cdot A}.
}
\description{
Product between a Filebacked Big Matrix and a matrix.
}
\section{Matrix parallelization}{

Large matrix computations are made block-wise and won't be parallelized
in order to not have to reduce the size of these blocks.
Instead, you may use \href{https://mran.microsoft.com/open/}{Microsoft R Open}
or OpenBLAS in order to accelerate these block matrix computations.
You can also control the number of cores used with
\code{bigparallelr::set_blas_ncores()}.
}

\examples{
X <- big_attachExtdata()
n <- nrow(X)
m <- ncol(X)
A <- matrix(0, m, 10); A[] <- rnorm(length(A))

test <- big_prodMat(X, A)
true <- X[] \%*\% A
all.equal(test, true)

X2 <- big_copy(X, type = "double")
all.equal(X2 \%*\% A, true)

# subsetting
ind.row <- sample(n, n/2)
ind.col <- sample(m, m/2)

tryCatch(test2 <- big_prodMat(X, A, ind.row, ind.col),
         error = function(e) print(e))
# returns an error. You need to use the subset of A:
test2 <- big_prodMat(X, A[ind.col, ], ind.row, ind.col)
true2 <- X[ind.row, ind.col] \%*\% A[ind.col, ]
all.equal(test2, true2)

}
