% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{big_increment}
\alias{big_increment}
\title{Increment an FBM}
\usage{
big_increment(X, add, use_lock = FALSE)
}
\arguments{
\item{X}{An \code{FBM} (of type double) to increment.}

\item{add}{A matrix of same dimensions as \code{X}. Or a vector of same size.}

\item{use_lock}{Whether to use locks when incrementing. Default is \code{FALSE}.
This is useful when incrementing in parallel.}
}
\value{
Returns nothing (\code{NULL}, invisibly).
}
\description{
Increment an FBM
}
\examples{
X <- FBM(10, 10, init = 0)
mat <- matrix(rnorm(100), 10, 10)

big_increment(X, mat)
all.equal(X[], mat)

big_increment(X, mat)
all.equal(X[], 2 * mat)

}
