% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier-hist.R
\name{nclass.scottRob}
\alias{nclass.scottRob}
\title{Compute the Number of Classes for a Histogram}
\usage{
nclass.scottRob(x)
}
\arguments{
\item{x}{a data vector.}
}
\value{
The suggested number of classes.
}
\description{
Compute the Number of Classes for a Histogram
}
\examples{
x <- rnorm(1000)
hist(x, breaks = nclass.scott)
hist(x, breaks = nclass.scottRob)

x2 <- c(x, rnorm(50, mean = 50))
hist(x2, breaks = nclass.scott)
hist(x2, breaks = nclass.scott,    xlim = c(-5, 5))
hist(x2, breaks = nclass.scottRob, xlim = c(-5, 5))

}
\references{
Scott, D. W. (1979). On optimal and data-based histograms.
Biometrika, 66, 605–610. doi: 10.2307/2335182.
}
