% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step4_rpl_e.R
\name{rpl_e}
\alias{rpl_e}
\title{Step 4: Replaying the experiment with optimal parameters}
\usage{
rpl_e(
  data,
  id = NULL,
  result,
  model,
  model_name,
  param_prefix,
  n_trials = NULL
)
}
\arguments{
\item{data}{[data.frame]
This data should include the following mandatory columns: 
 \itemize{
   \item "sub"
   \item "time_line" (e.g., "Block", "Trial")
   \item "L_choice"
   \item "R_choice"
   \item "L_reward"
   \item "R_reward"
   \item "sub_choose"
 }}

\item{id}{[vector] Participant IDs for subjects who need to replay the 
experiment.}

\item{result}{[data.frame]
Output data generated by the `fit_p()` function. Each row represents 
 model fit results for a subject.}

\item{model}{[function]
A model function to be applied in evaluating the experimental effect.}

\item{model_name}{[character]
A character string specifying the name of the model to extract from 
the result.}

\item{param_prefix}{[character]
A prefix string used to identify parameter columns in the 
`result` data (e.g., "param_").}

\item{n_trials}{[integer]
Number of total trials in the experimental task.}
}
\value{
A list, where each element is a data.frame representing one subject's
results. Each data.frame includes the value update history for each option,
the learning rate (\code{eta}), discount rate (\code{gamma}), and other 
relevant information used in each update.
}
\description{
This function takes the optimal parameters generated by `fit_p` and applies 
them back to each subject's data to generate a new column, `Rob_Choose`. 
This allows users to analyze whether the reinforcement learning model can 
reproduce the original experimental effects observed in the data.
}
