% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchCallGeno.R
\name{batchCallGeno}
\alias{batchCallGeno}
\title{Genotyping all sample by chromsome}
\usage{
batchCallGeno(x, CHROM, outdir = ".", window.size = 15,
  low.count = 6, high.count = 24, fix.size = 5, pos.start = 6,
  pdf.height = 4, pdf.width = 8)
}
\arguments{
\item{x}{GT matrix}

\item{CHROM}{chromosome vector}

\item{outdir}{outdir}

\item{window.size}{parameter of callWindowGeno}

\item{low.count}{parameter of callWindowGeno}

\item{high.count}{parameter of callWindowGeno}

\item{fix.size}{parameter of fixGenoError}

\item{pos.start}{position start index,
for exmaple, the pos.start of chr1_1234 is 6, chr01_1234 is 7}

\item{pdf.height}{pdf width}

\item{pdf.width}{pdf width}
}
\value{
A list object including genotype of each chromosome. It will
also create PDF and CSV of these genotype.
}
\description{
The genotype of each sample will be called according to
their allele depth, and then the potential error will be fixed.
}
\examples{
data(geno) 
GT <- as.matrix(geno[1:100,5:6])
row.names(GT) <- paste0(geno$CHR[1:100], "_", geno$POS[1:100])
temp_dir <- tempdir()
gt <- batchCallGeno(GT, "chr01",  outdir = temp_dir, pos.start = 7)

}
\author{
Zhougeng xu
}
