#-------------------------------------------------------------------------------
#
# Package binr 
#
# General description 
# 
# Sergei Izrailev, 2011-2014
#-------------------------------------------------------------------------------
# Copyright 2011-2014 Collective, Inc.
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
# http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#-------------------------------------------------------------------------------
#' Package \code{binr} (pronounced as "binner") provides algorithms for cutting 
#' numerical values exhibiting a potentially highly skewed distribution into 
#' evenly distributed groups (bins). This functionality can be applied for 
#' binning discrete values, such as counts, as well as for discretization of 
#' continuous values, for example, during generation of features used in machine 
#' learning algorithms.
#' 
#' @name binr
#' @aliases binr
#' @seealso \code{\link{bins}}, \code{\link{bins.quantiles}}, \code{\link{bins.optimize}}, \code{\link{bins.greedy}} 
#' @docType package
#' @title Cut Numeric Values Into Evenly Distributed Groups (bins). 
#' @author Sergei Izrailev
#' @section Maintainer: Sergei Izrailev 
#' @section Copyright: Copyright (C) Collective, Inc.
#' @section License: Apache License, Version 2.0, 
#'    available at http://www.apache.org/licenses/LICENSE-2.0
#' @section URL: http://github.com/collectivemedia/binr
#' @section Installation from github: 
#' \code{devtools::install_github("collectivemedia/binr")}
#' @keywords csv delimited file read.csv bigint 64-bit integer64
#' 
# The next and last line should be the word 'NULL'.
NULL
