% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biounit.R
\name{biounit}
\alias{biounit}
\title{Biological Units Construction}
\usage{
biounit(pdb, biomat = NULL, multi = FALSE, ncore = NULL)
}
\arguments{
\item{pdb}{an object of class \code{pdb} as obtained from
function \code{\link{read.pdb}}.}

\item{biomat}{a list object as returned by \code{read.pdb} 
(pdb$remark$biomat), containing matrices for 
symmetry operation on individual chains to build biological units.
It will override the matrices stored in \code{pdb}.}

\item{multi}{logical, if TRUE the biological unit is returned as a 
'multi-model' \code{pdb} object with each symmetric copy a distinct
structural 'MODEL'. Otherwise, all copies are represented 
as separated chains.}

\item{ncore}{number of CPU cores used to do the calculation. By default
(\code{ncore=NULL}), use all available CPU cores.}
}
\value{
a list of \code{pdb} objects with each representing an individual 
   biological unit.
}
\description{
Construct biological assemblies/units based on a 'pdb' object.
}
\details{
A valid structural/simulation study should be performed on the biological 
unit of a protein system. For example, the alpha2-beta2 tetramer form of
hemoglobin. However, canonical PDB files usually contain the asymmetric unit of 
the crystal cell, which can be:
\enumerate{
     \item One biological unit 
     \item A portion of a biological unit 
     \item Multiple biological units
}
The function performs symmetry operations to the coordinates based on the 
transformation matrices stored in a 'pdb' object returned by 
\code{\link{read.pdb}}, and returns biological units stored as a list of
\code{pdb} objects.
}
\examples{
\donttest{
   # PDB server connection required - testing excluded

   pdb <- read.pdb("2dn1")
   biounit <- biounit(pdb)
   pdb
   biounit
}
\dontrun{
   biounit <- biounit(read.pdb("2bfu"), multi=TRUE)
   write.pdb(biounit[[1]], file="biounit.pdb")
   # open the pdb file in VMD to have a look on the biological unit
} 
}
\author{
Xin-Qiu Yao
}
\seealso{
\code{\link{read.pdb}}
}

