% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isothermal_sensitivities.R
\name{isothermal_sensitivities}
\alias{isothermal_sensitivities}
\title{Local sensitivites of isothermal microbial inactivation}
\usage{
isothermal_sensitivities(model, exp_design, pars)
}
\arguments{
\item{model}{character defining the inactivation model according to the rules
in the \code{bioinactivation} package.}

\item{exp_design}{data.frame with two columns named \code{times} and 
\code{temperature} describing the experiment design.}

\item{pars}{list defining the model parameters according to the rules defined
in the \code{bioinactivation} package.}
}
\value{
A list of class \code{"IsoSensitivities"} with 3 entries:
\describe{
  \item{model}{Inactivation model.}
  \item{pars}{Model parameters used for the calculations.}
  \item{sensitivities}{data.frame adding columns to exp_design with the 
  calculated sensitivities. Local sensitivities are named as the parameters,
  scaled sensitivities as parameter_name+_scaled.}
}
}
\description{
Local sensitivites of isothermal microbial inactivation
}
\examples{

library("tidyverse")
time_profile <- seq(0, 50, length = 20)
Temp_profile <- seq(52.5,60, length = 3)

exp_design <- expand.grid(time_profile,Temp_profile) \%>\%
  rename(times = Var1, temperature = Var2)

pars <- list(z = 4.2, D_R = 3.9, temp_ref = 55)

my_sensitivities <- isothermal_sensitivities("Bigelow", exp_design, pars)
plot(my_sensitivities)
plot(my_sensitivities, limit = 6)

}
