% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nexrad_odim.R
\name{nexrad_to_odim}
\alias{nexrad_to_odim}
\title{Convert a NEXRAD polar volume file to an ODIM polar volume file}
\usage{
nexrad_to_odim(
  pvolfile_nexrad,
  pvolfile_odim,
  verbose = FALSE,
  mount = dirname(pvolfile_nexrad)
)
}
\arguments{
\item{pvolfile_nexrad}{Polar volume input file in RSL format.}

\item{pvolfile_odim}{Filename for the polar volume in ODIM hdf5 format to be
generated.}

\item{verbose}{logical. When TRUE, pipe Docker stdout to R console. On
Windows always TRUE.}

\item{mount}{character. String with the mount point (a directory path) for
the Docker container.}
}
\value{
\code{TRUE} on success
}
\description{
Convert a NEXRAD polar volume file to an ODIM polar volume file
}
\examples{
\dontrun{
# download a NEXRAD file, save as KBGM_example
download.file(paste("https://noaa-nexrad-level2.s3.amazonaws.com/",
  "2019/10/01/KBGM/KBGM20191001_000542_V06",
  sep = ""
), "~/KBGM_example")

# convert to ODIM format
nexrad_to_odim("~/KBGM_example", "~/KBGM_example.h5")

# verify that we have generated a polar volume in ODIM hdf5 format
get_odim_object_type("~/KBGM_example.h5")

# clean up
file.remove("~/KBGM_example", "~/KBGM_example.h5")
}
}
