% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_vpfiles.R
\name{download_vpfiles}
\alias{download_vpfiles}
\title{Download vertical profile (\code{vp}) files from the ENRAM data repository}
\usage{
download_vpfiles(
  date_min,
  date_max,
  radars,
  directory = ".",
  overwrite = FALSE
)
}
\arguments{
\item{date_min}{character. YYYY-MM-DD start date of file selection. Days will
be ignored.}

\item{date_max}{character. YYYY-MM-DD end date of file selection. Days will
be ignored.}

\item{radars}{character (vector). 5-letter country/radar code(s)
(e.g. "bejab") of radars to include in file selection.}

\item{directory}{character. Path to local directory where files should be
downloaded and unzipped.}

\item{overwrite}{logical. TRUE for re-downloading and overwriting previously
downloaded files of the same names.}
}
\description{
Download and unzip a selection of vertical profile (\code{vp}) files from the
\href{http://enram.github.io/data-repository/}{ENRAM data repository}, where
these are stored as monthly zips per radar.
}
\examples{
# Download data from radars "bejab" and "bewid", even if previously
# downloaded (overwrite = TRUE). Will successfully download 2016-10 files,
# but show 404 error for 2016-11 files (as these are not available).
\dontrun{
dir.create("~/bioRad_tmp_files")
download_vpfiles(
  date_min = "2016-10-01",
  date_max = "2016-11-30",
  radar = c("bejab", "bewid"),
  directory = "~/bioRad_tmp_files",
  overwrite = TRUE
)
# clean up:
unlink("~/bioRad_tmp_files", recursive = T)
}
}
\seealso{
select_vpfiles
}
