% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppi.R
\name{summary.ppi}
\alias{summary.ppi}
\alias{is.ppi}
\alias{dim.ppi}
\title{Inspect a plan position indicator (\code{ppi})}
\usage{
\method{summary}{ppi}(object, ...)

is.ppi(x)

\method{dim}{ppi}(x)
}
\arguments{
\item{object}{A \code{ppi} object.}

\item{...}{Additional arguments affecting the summary produced.}

\item{x}{A \code{ppi} object.}
}
\value{
For \code{\link[=is.ppi]{is.ppi()}}: \code{TRUE} for an object of class \code{ppi}, otherwise
\code{FALSE}.

For \code{\link[=dim.ppi]{dim.ppi()}}: number of parameters (\code{param}), x and y pixels in a
plan position indicator (\code{ppi}).
}
\description{
R base functions for inspecting a plan position indicator (\code{ppi}) object.
}
\details{
A plan position indicator is a projection of radar data onto the earth's
surface, generated from a single scan (\code{scan}) with \code{\link[=project_as_ppi]{project_as_ppi()}}, a
polar volume (\code{pvol}) with \code{\link[=integrate_to_ppi]{integrate_to_ppi()}} or multiple plan position
indicators (\code{ppi}) with \code{\link[=composite_ppi]{composite_ppi()}}. A plan position indicator (\code{ppi})
object is a list containing:
\itemize{
\item \code{radar}: Radar identifier.
\item \code{datetime}: Nominal time of the volume to which the scan belongs in UTC.
\item \code{data}: A \code{\link[sp:SpatialGridDataFrame]{sp::SpatialGridDataFrame}} containing the georeferenced data.
See \code{\link[=summary.param]{summary.param()}} for commonly available parameters, such as \code{DBZH}.
\item \code{geo}: List of the scan's geographic properties (see the \code{geo} element in
\code{\link[=summary.scan]{summary.scan()}}), with two additional properties:
\itemize{
\item \code{bbox}: Bounding box for the plan position indicator in decimal degrees.
\item \code{merged}: Logical. Flag to indicate if a plan position indicator is a
composite of multiple scans. \code{TRUE} if generated with \code{\link[=integrate_to_ppi]{integrate_to_ppi()}}
or \code{\link[=composite_ppi]{composite_ppi()}}.
}
}
}
\examples{
# Project a scan as a ppi
ppi <- project_as_ppi(example_scan)

# Check if it is an object of class ppi
is.ppi(ppi)

# Get summary info
ppi # Same as summary(ppi) or print(ppi)

# Get dimensions
dim(ppi)
}
\seealso{
\itemize{
\item \code{\link[=project_as_ppi]{project_as_ppi()}}
\item \code{\link[=integrate_to_ppi]{integrate_to_ppi()}}
\item \code{\link[=plot.ppi]{plot.ppi()}}
\item \code{\link[=map]{map()}}
\item \code{\link[=composite_ppi]{composite_ppi()}}
\item \code{\link[=[.ppi]{[ppi()}}
}
}
