% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_thorntwaitemod.R
\name{thornthwaite}
\alias{thornthwaite}
\title{Function to calculate Thornthwaite potential evapotranspiration}
\usage{
thornthwaite(Tave, lat, na.rm = FALSE)
}
\arguments{
\item{Tave}{a numeric vector, matrix or time series of monthly mean temperatures, ºC.}

\item{lat}{a numeric vector with the latitude of the site or sites, in degrees.}

\item{na.rm}{optional, a logical value indicating whether NA values should be stripped from the computations.}
}
\value{
A time series with the values of monthly potential or reference evapotranspiration, in mm. If the input is a matrix or a multivariate time series each column will be treated as independent data (e.g., diferent observatories), and the output will be a multivariate time series.
}
\description{
This function calculates Thornthwaite’s potential evapotranspiration.
}
\details{
This function is a modified version of SPEI::thornthwaite() function.
}
\examples{
thornthwaite(rnorm(12, 18, 6), 35)
}
\author{
Santiago Begueria
}
