% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate-checksum.R
\name{validate_checksum_v1.3.0}
\alias{validate_checksum_v1.3.0}
\alias{validate_checksum}
\title{BioCompute Objects checksum validator (v1.3.0)}
\usage{
validate_checksum_v1.3.0(file)

validate_checksum(file)
}
\arguments{
\item{file}{Path to the BCO JSON file}
}
\value{
Logical. \code{TRUE} if the checksum matched, \code{FALSE} if not.
}
\description{
BioCompute Objects checksum validator (v1.3.0)
}
\note{
An SHA-256 checksum is
\href{https://github.com/biocompute-objects/BCO_Specification/blob/master/top-level.md#203-checksum-checksum}{calculated and stored}
in the top level fields when a BioCompute Object is created. In reality,
due to the delicate differences in how the data in JSON is represented,
parsed, and handled in different languages, there could be false positives
in the validation results.
}
\examples{
bco <- tempfile(fileext = ".json")
generate_example("HCV1a") \%>\%
  convert_json() \%>\%
  export_json(bco)
bco \%>\% validate_checksum()
}
