% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcs_mixed.R
\name{fun.estimate.criticality}
\alias{fun.estimate.criticality}
\title{Calculate absorbed dose for mixed fields exposure}
\usage{
fun.estimate.criticality(
  num_cases,
  dics,
  cells,
  coef_gamma,
  cov_gamma,
  coef_neutron,
  cov_neutron,
  ratio,
  p
)
}
\arguments{
\item{num_cases}{number of cases to estimate.}

\item{dics}{dicentrics.}

\item{cells}{total cells.}

\item{coef_gamma}{Coefficients for gamma curve.}

\item{cov_gamma}{Covariance matrix for gamma curve.}

\item{coef_neutron}{Coefficients for neutron curve.}

\item{cov_neutron}{Covariance matrix for neutron curve.}

\item{ratio}{gamma-neutron ratio.}

\item{p}{photon contribution in mixed curve.}
}
\value{
dose estimation
}
\description{
Calculate absorbed dose for mixed fields exposure
}
\examples{
#Results from the fitting module
fit_results_gamma <- system.file("extdata",
                                 "gamma_dicentrics-fitting-results.rds",
                                 package = "biodosetools") \%>\%
  readRDS()

fit_results_neutrons <- system.file("extdata",
                                    "neutrons-mixed-dicentrics-fitting-results.rds",
                                    package = "biodosetools") \%>\%
  readRDS()

#FUNCTION TO ESTIMATE DOSE IN CRITICALITY ACCIDENTS
fun.estimate.criticality(num_cases = 2,
                         dics = c(380,456),
                         cells = c(218,567),
                         coef_gamma = fit_results_gamma[["fit_coeffs"]][,1],
                         cov_gamma = fit_results_gamma[["fit_var_cov_mat"]],
                         coef_neutron = fit_results_neutrons[["fit_coeffs"]][,1],
                         cov_neutron = fit_results_neutrons[["fit_var_cov_mat"]],
                         ratio = 1.2,
                         p = 0)
}
