% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/gbFeature-class.R,
%   R/gbFeatureTable-class.R, R/gbRecord-class.R
\docType{methods}
\name{location}
\alias{location}
\alias{location,gbFeature-method}
\alias{location,gbFeatureTable-method}
\alias{location,gbRecord-method}
\title{Access genomic locations of GenBank features}
\usage{
location(x, ...)

\S4method{location}{gbFeature}(x)

\S4method{location}{gbFeatureTable}(x, join = FALSE)

\S4method{location}{gbRecord}(x, join = FALSE)
}
\arguments{
\item{x}{A \code{\linkS4class{gbFeature}}, \code{\linkS4class{gbFeatureTable}}, or
\code{\linkS4class{gbRecord}} object.}

\item{...}{Additional arguments passed to methods.}

\item{join}{Join compound genomic locations to a single range.}
}
\value{
A list of \code{\linkS4class{gbLocation}} objects
}
\description{
Access genomic locations of GenBank features
}
\examples{
load(system.file("extdata", "marine_metagenome.rda", package = "biofiles"))
location(x)
}
