% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/gbFeatureTable-class.R,
%   R/gbRecord-class.R, R/gbRecordList-class.R
\docType{methods}
\name{qualifTable}
\alias{qualifTable}
\alias{qualifTable,gbFeatureTable-method}
\alias{qualifTable,gbRecord-method}
\alias{qualifTable,gbRecordList-method}
\title{Tabulate Genbank qualifiers}
\usage{
qualifTable(x, ...)

\S4method{qualifTable}{gbFeatureTable}(x)

\S4method{qualifTable}{gbRecord}(x)

\S4method{qualifTable}{gbRecordList}(x)
}
\arguments{
\item{x}{A \code{\linkS4class{gbFeatureTable}}, \code{\linkS4class{gbRecord}},
or \code{\linkS4class{gbRecordList}} object.}

\item{...}{Additional arguments to be passed to or from methods.}
}
\value{
A \code{\link{table}} (or list of \code{table}s) of 
   qualifiers names.
}
\description{
Extract a frequency table (or list of tables in the case of
\code{gbRecordList}s) of qualifier names.
}
\examples{
load(system.file("extdata", "marine_metagenome.rda", package = "biofiles"))
qualifTable(x)
}
\seealso{
\code{\link{uniqueQualifs}}, \code{\link{hasQualif}}
}
