% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/count_ngrams.R
\name{count_ngrams}
\alias{count_ngrams}
\title{Count n-grams in sequences}
\usage{
count_ngrams(seq, n, u, d = 0, pos = FALSE, scale = FALSE,
  threshold = 0)
}
\arguments{
\item{seq}{a vector or matrix describing sequence(s).}

\item{n}{\code{integer} size of n-gram.}

\item{u}{\code{integer}, \code{numeric} or \code{character} vector of all
possible unigrams.}

\item{d}{\code{integer} vector of distances between elements of n-gram (0 means
consecutive elements). See Details.}

\item{pos}{\code{logical}, if \code{TRUE} position-specific n_grams are counted.}

\item{scale}{\code{logical}, if \code{TRUE} output data is normalized. Should be
used only for n-grams without position information. See \code{Details}.}

\item{threshold}{\code{integer}, if not equal to 0, data is binarized into
two groups (larger or equal to threshold vs. smaller than threshold).}
}
\value{
a \code{\link[slam]{simple_triplet_matrix}} where columns represent
n-grams and rows sequences. See \code{Details} for specifics of the naming convention.
}
\description{
Counts all n-grams or position-specific n-grams present in the input sequence(s).
}
\details{
A \code{distance} vector should be always \code{n} - 1 in length.
For example when \code{n} = 3, \code{d} = c(1,2) means A_A__A. For \code{n} = 4,
\code{d} = c(2,0,1) means A__AA_A. If vector \code{d} has length 1, it is recycled to
length \code{n} - 1.

n-gram names follow a specific convention and have three parts for position-specific
n-grams and two parts otherwise. The parts are separated by \code{_}. The \code{.} symbol
is used to separate elements within a part. The general naming scheme is
\code{POSITION_NGRAM_DISTANCE}. The optional \code{POSITION} part of the name indicates
the actual position of the n-gram in the sequence(s) and will be present
only if \code{pos} = \code{TRUE}. This part is always a single integer. The \code{NGRAM}
part of the name is a sequence of elements in the n-gram. For example, \code{4.2.2}
indicates the n-gram 422 (e.g. TCC). The \code{DISTANCE} part of the name is a vector of
distance(s). For example, \code{0.0} indicates zero distances (continuous n-grams), while
\code{1.2} represents distances for the n-gram A_A__A.

Examples of n-gram names:
\itemize{
\item{46_4.4.4_0.1 : trigram 44_4 on position 46}
\item{12_2.1_2     : bigram 2__1 on position 12}
\item{8_1.1.1_0.0  : continuous trigram 111 on position 8}
\item{1.1.1_0.0    : continuous trigram 111 without position information}
}
}
\note{
By default, the counted n-gram data is stored in a memory-saving format.
To convert an object to a 'classical' matrix use the \code{\link[base]{as.matrix}}
function. See examples for further information.
}
\examples{
#count trigrams without position information for nucleotides
count_ngrams(sample(1L:4, 50, replace = TRUE), 3, 1L:4, pos = FALSE)
#count position-specific trigrams from multiple nucleotide sequences
seqs <- matrix(sample(1L:4, 600, replace = TRUE), ncol = 50)
ngrams <- count_ngrams(seqs, 3, 1L:4, pos = TRUE)
#output results of the n-gram counting to screen
as.matrix(ngrams)
}
\seealso{
Create vector of possible n-grams: \code{\link{create_ngrams}}.

Extract n-grams from sequence(s): \code{\link{seq2ngrams}}.

Get indices of n-grams: \code{\link{get_ngrams_ind}}.

Count n-grams for multiple values of n: \code{\link{count_multigrams}}.

Count only specified n-grams: \code{\link{count_specified}}.
}

