% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information_gain.R
\name{calc_ig}
\alias{calc_ig}
\title{Calculate IG for single feature}
\usage{
calc_ig(feature, target_b, len_target, pos_target)
}
\arguments{
\item{feature}{feature vector.}

\item{target_b}{target in bits (as per \code{\link[bit]{as.bit}}).}

\item{len_target}{length of the target vector.}

\item{pos_target}{number of positive cases in the target vector.}
}
\value{
A \code{numeric} vector of length 1 representing information gain in nats.
}
\description{
Computes information gain of single feature and target vector.
}
\details{
The information gain term is used here (improperly) as a synonym of mutual 
information. It is defined as:
\deqn{IG(X; Y) = \sum_{y \in Y} \sum_{x \in X} p(x, y) \log \left(\frac{p(x, y)}{p(x) p(y)}  \right)}

In biogram package information gain is computed using following relationship: 
\eqn{IG = E(S) - E(S|F)}
}
\note{
During calculations \eqn{0 \log 0  = 0}. For a justification see References. 

The function was designed to be as fast as possible subroutine of 
\code{\link{calc_criterion}} and might be cumbersome if directly called by a user.
}
\examples{
tar <- sample(0L:1, 100, replace = TRUE)
feat <- sample(0L:1, 100, replace = TRUE)
library(bit) # used to code vector as bit
calc_ig(feat, as.bit(tar), 100, sum(tar))
}
\references{
Cover TM, Thomas JA \emph{Elements of Information Theory, 2nd Edition}
Wiley, 2006.
}

