% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_counts.R
\name{distribution_to_logcount}
\alias{distribution_to_logcount}
\title{Distribution of times to reach a certain microbial count}
\usage{
distribution_to_logcount(model, log_count)
}
\arguments{
\item{model}{An instance of \code{StochasticGrowth} or \code{MCMCgrowth}.}

\item{log_count}{The target microbial count.}
}
\value{
A list of class \code{TimeDistribution} with the items:
\itemize{
\item distribution Sample of the distribution of times to reach \code{log_count}.
\item summary Summary statistics of distribution (mean, sd, median, q10 and q90).
}
}
\description{
Returns the probability distribution of the storage time required for
the microbial count to reach \code{log_count} according to the predictions of
a stochastic \code{model}.
Calculations are done using linear interpolation of the individual
 model predictions.
}
\examples{
\donttest{
## We need an instance of StochasticGrowth

my_model <- "Trilinear"
my_times <- seq(0, 30, length = 100)
n_sims <- 3000

stoc_growth <- predict_stochastic_growth(my_model, my_times, n_sims,
    mean_logN0 = 0, sd_logN0 = .2,
    mean_sqmu = 2,sd_sqmu = .3,
    mean_sqlambda = 4, sd_sqlambda = .4,
    mean_logNmax = 6, sd_logNmax = .5)

## We can now call the function

time_distrib <- distribution_to_logcount(stoc_growth, 4)

## And plot the results

plot(time_distrib)
}

}
