% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_isothermal_growth.R
\name{predict_isothermal_growth}
\alias{predict_isothermal_growth}
\title{Isothermal microbial growth}
\usage{
predict_isothermal_growth(model_name, times, model_pars, check = TRUE)
}
\arguments{
\item{model_name}{Character defining the growth model.}

\item{times}{Numeric vector of storage times for the predictions.}

\item{model_pars}{List defining the values of the model parameters.}

\item{check}{Whether to do basic checks (TRUE by default).}
}
\value{
A list of class \code{IsothermalGrowth} with the items:
\itemize{
\item simulation: A tibble with the model simulation.
\item model: The name of the model used for the predictions.
\item pars: A list with the values of the model parameters.
}
}
\description{
Predicts microbial growth under isothermal conditions according to
models commonly used in predictive microbiology.
}
\examples{
## Define the simulations parameters

my_model <- "modGompertz"
my_pars <- list(logN0 = 2, C = 6, mu = .2, lambda = 25)
my_time <- seq(0, 100, length = 1000)

## Do the simulation

static_prediction <- predict_isothermal_growth(my_model, my_time, my_pars)

## Plot the results

plot(static_prediction)


}
