% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_asreml.R
\name{install_asreml}
\alias{install_asreml}
\alias{update_asreml}
\title{Install or update the ASReml-R package}
\usage{
install_asreml(
  library = .libPaths()[1],
  quiet = FALSE,
  force = FALSE,
  keep_file = FALSE,
  check_version = TRUE
)

update_asreml(...)
}
\arguments{
\item{library}{Library location to install ASReml-R. Uses first option in \code{.libPaths()} by default.}

\item{quiet}{Logical (default \code{FALSE}). Should package be installed quietly?}

\item{force}{Logical (default \code{FALSE}). Force ASReml-R to install. Useful for upgrading if it is already installed.}

\item{keep_file}{Should the downloaded asreml package file be kept? Default is \code{FALSE}. \code{TRUE} downloads to current directory. A file path can also be provided to save to another directory. See \code{Details} for more information.}

\item{check_version}{Logical (default \code{TRUE}). Should function check if there is a newer version of asreml available before attempting to download and install?}

\item{...}{other arguments passed to \code{install_asreml()}}
}
\value{
Silently returns \code{TRUE} if \code{asreml} installed successfully or already present, \code{FALSE} otherwise. Optionally prints a confirmation message on success.
}
\description{
Helper functions for installing or updating the ASReml-R package, intended to reduce the difficulty of finding the correct version for your operating system and R version.
}
\details{
The ASReml-R package file is downloaded from a shortlink, and if \code{keep_file} is \code{TRUE}, the package archive file will be saved in the current directory. If a valid path is provided in \code{keep_file}, the file will be saved to that path, but all directories are assumed to exist and will not be created. If \code{keep_file} does not specify an existing, valid path, an error will be shown after package installation.
}
\examples{
\dontrun{
# Example 1: download and install asreml
install_asreml()

# Example 2: install asreml and save file for later
install_asreml(keep_file = TRUE)
}

}
