% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_PlotRangeSize.R
\name{bm_PlotRangeSize}
\alias{bm_PlotRangeSize}
\title{Plot species range change}
\usage{
bm_PlotRangeSize(
  bm.range,
  do.count = TRUE,
  do.perc = TRUE,
  do.maps = TRUE,
  do.mean = TRUE,
  do.plot = TRUE,
  row.names = c("Species", "Dataset", "Run", "Algo")
)
}
\arguments{
\item{bm.range}{an object returned by the \code{\link{BIOMOD_RangeSize}} function}

\item{do.count}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} value defining whether the count plot is to be computed or not}

\item{do.perc}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} value defining whether the percentage plot is to be computed or not}

\item{do.maps}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} value defining whether the maps plot is to be computed or not}

\item{do.mean}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} value defining whether the mean maps plot is to be computed or not}

\item{do.plot}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} value defining whether the plots are to be rendered or not}

\item{row.names}{(\emph{optional, default} \code{c('Species', 'Dataset', 'Run', 'Algo')}) \cr 
A \code{vector} containing tags matching \code{bm.range$Compt.By.Models} rownames splitted by 
'_' character}
}
\value{
A \code{list} containing one or several \code{data.frame} and the corresponding 
\code{ggplot} object representing species range change.
}
\description{
This function represents species range change from object that can be obtained 
from \code{\link{BIOMOD_RangeSize}} function. Several graphics can be obtained, representing 
global counts or proportions of gains / losses, as well as spatial representations (see Details).
}
\details{
4 plots can be obtained with this function :
\describe{
  \item{Count barplot}{representing absolute number of locations (pixels) lost, stable and 
  gained}
  \item{Percentage barplot}{representing percentage of locations (pixels) lost, stable, and 
  the corresponding Species Range Change (\code{PercGain - PercLoss})}
  \item{SRC models maps}{representing spatially locations (pixels) lost, stable and 
  gained for each single distribution model}
  \item{SRC community averaging maps}{representing spatially locations (pixels) lost, stable 
  and gained, taking the majoritary value across single distribution models (and representing 
  the percentage of models' agreement)}
}
\emph{Please see \code{\link{BIOMOD_RangeSize}} function for more details about the values.}
}
\examples{
library(terra)

# Load species occurrences (6 species available)
data(DataSpecies)
head(DataSpecies)

# Select the name of the studied species
myRespName <- 'GuloGulo'

# Get corresponding presence/absence data
myResp <- as.numeric(DataSpecies[, myRespName])

# Get corresponding XY coordinates
myRespXY <- DataSpecies[, c('X_WGS84', 'Y_WGS84')]

# Load environmental variables extracted from BIOCLIM (bio_3, bio_4, bio_7, bio_11 & bio_12)
data(bioclim_current)
myExpl <- terra::rast(bioclim_current)

\dontshow{
myExtent <- terra::ext(0,30,45,70)
myExpl <- terra::crop(myExpl, myExtent)
}

# ---------------------------------------------------------------#
file.out <- paste0(myRespName, "/", myRespName, ".AllModels.models.out")
if (file.exists(file.out)) {
  myBiomodModelOut <- get(load(file.out))
} else {

  # Format Data with true absences
  myBiomodData <- BIOMOD_FormatingData(resp.var = myResp,
                                       expl.var = myExpl, 
                                       resp.xy = myRespXY,
                                       resp.name = myRespName)

  # Model single models
  myBiomodModelOut <- BIOMOD_Modeling(bm.format = myBiomodData,
                                      modeling.id = 'AllModels',
                                      models = c('RF', 'GLM'),
                                      CV.strategy = 'random',
                                      CV.nb.rep = 2,
                                      CV.perc = 0.8,
                                      OPT.strategy = 'bigboss',
                                      metric.eval = c('TSS','ROC'),
                                      var.import = 3,
                                      seed.val = 42)
}

models.proj <- get_built_models(myBiomodModelOut, algo = "RF")
  # Project single models
  myBiomodProj <- BIOMOD_Projection(bm.mod = myBiomodModelOut,
                                    proj.name = 'CurrentRangeSize',
                                    new.env = myExpl,
                                    models.chosen = models.proj,
                                    metric.binary = 'all')



# ---------------------------------------------------------------#
# Load environmental variables extracted from BIOCLIM (bio_3, bio_4, bio_7, bio_11 & bio_12)
data(bioclim_future)
myExplFuture <- terra::rast(bioclim_future)
\dontshow{
myExtent <- terra::ext(0,30,45,70)
myExplFuture <- terra::crop(myExplFuture, myExtent)
}

# Project onto future conditions
myBiomodProjectionFuture <- BIOMOD_Projection(bm.mod = myBiomodModelOut,
                                              proj.name = 'FutureRangeSize',
                                              new.env = myExplFuture,
                                              models.chosen = models.proj,
                                              metric.binary = 'TSS')

# Load current and future binary projections
CurrentProj <- get_predictions(myBiomodProj,
                               metric.binary = "TSS",
                               model.as.col = TRUE)
FutureProj <- get_predictions(myBiomodProjectionFuture,
                               metric.binary = "TSS",
                               model.as.col = TRUE)

# Compute differences
myBiomodRangeSize <- BIOMOD_RangeSize(proj.current = CurrentProj, proj.future = FutureProj)


# ---------------------------------------------------------------#
myBiomodRangeSize$Compt.By.Models
plot(myBiomodRangeSize$Diff.By.Pixel)

# Represent main results 
bm_PlotRangeSize(bm.range = myBiomodRangeSize)


}
\seealso{
\code{\link{BIOMOD_RangeSize}}

Other Secundary functions: 
\code{\link{bm_BinaryTransformation}()},
\code{\link{bm_CrossValidation}()},
\code{\link{bm_FindOptimStat}()},
\code{\link{bm_MakeFormula}()},
\code{\link{bm_ModelingOptions}()},
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()},
\code{\link{bm_PseudoAbsences}()},
\code{\link{bm_RunModelsLoop}()},
\code{\link{bm_SRE}()},
\code{\link{bm_SampleBinaryVector}()},
\code{\link{bm_SampleFactorLevels}()},
\code{\link{bm_Tuning}()},
\code{\link{bm_VariablesImportance}()}

Other Plot functions: 
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()}
}
\author{
Maya Gueguen
}
\concept{Plot functions}
\concept{Secundary functions}
\keyword{"species}
\keyword{change"}
\keyword{gain}
\keyword{ggplot}
\keyword{loss}
\keyword{projections}
\keyword{range}
