% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity_dissimilarity_conversion.R
\name{similarity_to_dissimilarity}
\alias{similarity_to_dissimilarity}
\title{Convert similarity metrics to dissimilarity metrics}
\usage{
similarity_to_dissimilarity(similarity, include_formula = TRUE)
}
\arguments{
\item{similarity}{the output object from \code{\link[=similarity]{similarity()}} or
\code{\link[=dissimilarity_to_similarity]{dissimilarity_to_similarity()}}.}

\item{include_formula}{a \code{boolean} indicating if the metrics based on your
own formula(s) should be converted (see Details). This argument is set to
\code{TRUE} by default.}
}
\value{
A \code{data.frame} with additional class
\code{bioregion.pairwise.metric}, providing dissimilarity
metric(s) between each pair of sites based on a similarity object.
}
\description{
This function converts a \code{data.frame} of similarity metrics between sites to
dissimilarity metrics (beta diversity).
}
\note{
\loadmathjax
The behavior of this function changes depending on column names. Columns
\code{Site1} and \code{Site2} are copied identically. If there are columns called
\code{a}, \code{b}, \code{c}, \code{A}, \code{B}, \code{C} they will also be copied identically. If there
are columns based on your own formula (argument \code{formula} in \code{\link[=similarity]{similarity()}})
or not in the original list of similarity metrics (argument \code{metrics} in
\code{\link[=similarity]{similarity()}}) and if the argument \code{include_formula} is set to \code{FALSE},
they will also be copied identically. Otherwise there are going to be
converted like they other columns (default behavior).

If a column is called \code{Euclidean}, its distance will be calculated based
on the following formula:

\mjeqn{Euclidean distance = (1 - Euclidean similarity) / Euclidean similarity}{Euclidean distance = (1 - Euclidean similarity) / Euclidean similarity}

Otherwise, all other columns will be transformed into dissimilarity with the
following formula:

\mjeqn{dissimilarity = 1 - similarity}{dissimilarity = 1 - similarity}
}
\examples{
comat <- matrix(sample(0:1000, size = 50, replace = TRUE,
prob = 1 / 1:1001), 5, 10)
rownames(comat) <- paste0("Site", 1:5)
colnames(comat) <- paste0("Species", 1:10)

simil <- similarity(comat, metric = "all")
simil

dissimilarity <- similarity_to_dissimilarity(simil)
dissimilarity

}
\seealso{
\code{\link[=dissimilarity_to_similarity]{dissimilarity_to_similarity()}} \code{\link[=similarity]{similarity()}} \code{\link[=dissimilarity]{dissimilarity()}}
}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr}),
Boris Leroy (\email{leroy.boris@gmail.com}) and
Pierre Denelle (\email{pierre.denelle@gmail.com})
}
