% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bx_search.R
\name{bx_search}
\alias{bx_search}
\title{Search biorxiv.org}
\usage{
bx_search(query, limit = 10)
}
\arguments{
\item{query}{The terms to search for in biorxiv.}
\item{limit}{The number of results to return.}
}
\value{
A list with the following elements:
\item{URL}{The URLs of the biorxiv papers from the search terms.}
\item{ID}{The IDs of the biorxiv papers from the search terms.}
\item{found}{The total number of papers found for the query.}
\item{query}{The query searched on biorixiv.}
\item{limit}{The number of results to return as set by the user.}
}
\description{
return a list of URLS, IDS and number of results found from search of biorxiv.org
}
\details{
This uses the generic search interface, therefore be aware that you'll have to do post download filtering if you want terms in a specific field
}
\examples{
bxEco <- bx_search("ecology",limit=1)
}

