% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_tibble.R
\name{as-tibble-bioseq}
\alias{as-tibble-bioseq}
\alias{as_tibble.bioseq_dna}
\alias{as_tibble.bioseq_rna}
\alias{as_tibble.bioseq_aa}
\title{Convert bioseq DNA, RNA and AA to tibble}
\usage{
as_tibble.bioseq_dna(x, label = "label", sequence = "sequence", ...)

as_tibble.bioseq_rna(x, label = "label", sequence = "sequence", ...)

as_tibble.bioseq_aa(x, label = "label", sequence = "sequence", ...)
}
\arguments{
\item{x}{a DNA, RNA or AA vector.}

\item{label}{Name of the column that stores the sequence
labels in the returned tibble.}

\item{sequence}{Name of the column that stores the sequences
in the returned tibble.}

\item{...}{Not used.}
}
\value{
A tibble with two columns (if name is not NULL, the default)
or one column (otherwise).
}
\description{
Convert bioseq DNA, RNA and AA to tibble
}
\examples{

require(tibble)
x <- dna(A = "ACGTTAGTGTAGCCGT", B = "CTCGAAATGA", C = NA)
as_tibble(x)


}
\seealso{
Other conversions: \code{\link{as-tibble-ape}},
  \code{\link{as_AAbin}}, \code{\link{as_DNAbin}},
  \code{\link{as_aa}}, \code{\link{as_dna}},
  \code{\link{as_rna}}, \code{\link{as_seqinr_alignment}}
}
\concept{conversions}
