% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_string_operation.R
\name{seq_combine}
\alias{seq_combine}
\title{Combine multiple sequences}
\usage{
seq_combine(..., sep = "", collapse = NULL)
}
\arguments{
\item{...}{One or more vectors of sequences (DNA, RNA, AA).
They must all be of the same type. Short vectors are recycled.}

\item{sep}{String to insert between input vectors.}

\item{collapse}{If not \code{NULL}, combine everything with this
string as separator.}
}
\value{
A vector of sequences (if collapse is \code{NULL}).
A vector with a single sequence, otherwise.
}
\description{
Combine multiple sequences
}
\details{
The strings \code{sep} and \code{collapse}w ill be coerced to
the type of input vectors with a warning if some character have to replaced.
}
\examples{

x <- dna("ACGTTAGTGTAGCCGT", "CTCGAAATGA")
y <- dna("TTTTTTTT", "AAAAAAAAA")
seq_combine(x, y)
seq_combine(y, x, sep = "CCCCC")
seq_combine(y, x, sep = "CCCCC", collapse = "GGGGG")

}
\seealso{
\code{\link[stringi]{stri_join}} from \pkg{stringi} and
\code{\link[stringr]{str_c}} from \pkg{stringr}
for the underlying implementation.

Other string operations: 
\code{\link{seq-replace}},
\code{\link{seq_count_pattern}()},
\code{\link{seq_crop_pattern}()},
\code{\link{seq_crop_position}()},
\code{\link{seq_detect_pattern}()},
\code{\link{seq_extract_pattern}()},
\code{\link{seq_extract_position}()},
\code{\link{seq_remove_pattern}()},
\code{\link{seq_remove_position}()},
\code{\link{seq_replace_position}()},
\code{\link{seq_split_kmer}()},
\code{\link{seq_split_pattern}()}
}
\concept{string operations}
