% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_string_operation.R
\name{seq_split_kmer}
\alias{seq_split_kmer}
\title{Split sequences into k-mers}
\usage{
seq_split_kmer(x, k)
}
\arguments{
\item{x}{A DNA, RNA or AA vector.}

\item{k}{an integer giving the size of the k-mer.}
}
\value{
a list of k-mer vectors of same class as \code{x}.
}
\description{
Split sequences into k-mers
}
\examples{

x <- dna(a ="ACGTTAGTGTAGCCGT", b = "CTCGAAATGA")
seq_split_kmer(x, k = 5)
}
\seealso{
\code{\link{seq_split_pattern}}.

Other string operations: 
\code{\link{seq-replace}},
\code{\link{seq_combine}()},
\code{\link{seq_count_pattern}()},
\code{\link{seq_crop_pattern}()},
\code{\link{seq_crop_position}()},
\code{\link{seq_detect_pattern}()},
\code{\link{seq_extract_pattern}()},
\code{\link{seq_extract_position}()},
\code{\link{seq_remove_pattern}()},
\code{\link{seq_remove_position}()},
\code{\link{seq_replace_position}()},
\code{\link{seq_split_pattern}()}
}
\concept{string operations}
