% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OrderByCrossover.R
\name{OrderByCrossover}
\alias{OrderByCrossover}
\title{Find Species Order That Minimises Crossover}
\usage{
OrderByCrossover(df)
}
\arguments{
\item{df}{A network in data.frame format. (row names for primary layer, column names for secondary layer)}
}
\value{
A list containing 'PrimaryOrder' and 'SecondaryOrder', to be used with bipartite_d3()
}
\description{
Find an order of species that is likely to minimise cross over.
It builds upon the 'cca' method used in the bipartite package, but orders the compartments by size,
which tends to give better effects.
}
\examples{

\dontrun{

data(Safariland, package='bipartite')


S_orders <- OrderByCrossover(Safariland)

bipartite_D3(Safariland,
  filename = 'SF_sorted',
  SortPrimary = S_orders[[1]],
  SortSecondary = S_orders[[2]])
}

}
