// Generated by rstantools.  Do not edit by hand.

#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_multinom_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 54> locations_array__ =
  {" (found before start of program)",
  " (in 'multinom', line 21, column 4 to column 30)",
  " (in 'multinom', line 22, column 4 to column 24)",
  " (in 'multinom', line 23, column 4 to column 25)",
  " (in 'multinom', line 24, column 4 to column 35)",
  " (in 'multinom', line 25, column 4 to column 32)",
  " (in 'multinom', line 28, column 4 to column 24)",
  " (in 'multinom', line 30, column 15 to column 16)",
  " (in 'multinom', line 30, column 18 to column 21)",
  " (in 'multinom', line 30, column 8 to column 31)",
  " (in 'multinom', line 31, column 15 to column 18)",
  " (in 'multinom', line 31, column 20 to column 23)",
  " (in 'multinom', line 31, column 8 to column 65)",
  " (in 'multinom', line 32, column 8 to column 70)",
  " (in 'multinom', line 34, column 8 to column 69)",
  " (in 'multinom', line 29, column 4 to line 35, column 5)",
  " (in 'multinom', line 38, column 4 to column 35)",
  " (in 'multinom', line 39, column 4 to column 37)",
  " (in 'multinom', line 40, column 4 to column 44)",
  " (in 'multinom', line 41, column 4 to column 32)",
  " (in 'multinom', line 43, column 4 to column 84)",
  " (in 'multinom', line 44, column 4 to column 31)",
  " (in 'multinom', line 2, column 4 to column 21)",
  " (in 'multinom', line 3, column 4 to column 19)",
  " (in 'multinom', line 4, column 4 to column 19)",
  " (in 'multinom', line 5, column 4 to column 23)",
  " (in 'multinom', line 6, column 11 to column 12)",
  " (in 'multinom', line 6, column 14 to column 15)",
  " (in 'multinom', line 6, column 4 to column 19)",
  " (in 'multinom', line 7, column 11 to column 12)",
  " (in 'multinom', line 7, column 14 to column 17)",
  " (in 'multinom', line 7, column 4 to column 21)",
  " (in 'multinom', line 8, column 15 to column 16)",
  " (in 'multinom', line 8, column 4 to column 20)",
  " (in 'multinom', line 9, column 10 to column 11)",
  " (in 'multinom', line 9, column 4 to column 43)",
  " (in 'multinom', line 10, column 4 to column 34)",
  " (in 'multinom', line 11, column 4 to column 30)",
  " (in 'multinom', line 12, column 4 to column 36)",
  " (in 'multinom', line 13, column 4 to column 29)",
  " (in 'multinom', line 14, column 4 to column 28)",
  " (in 'multinom', line 17, column 11 to column 14)",
  " (in 'multinom', line 17, column 4 to column 44)",
  " (in 'multinom', line 18, column 11 to column 12)",
  " (in 'multinom', line 18, column 4 to column 47)",
  " (in 'multinom', line 21, column 15 to column 18)",
  " (in 'multinom', line 22, column 11 to column 12)",
  " (in 'multinom', line 22, column 14 to column 17)",
  " (in 'multinom', line 23, column 11 to column 16)",
  " (in 'multinom', line 23, column 18 to column 21)",
  " (in 'multinom', line 24, column 20 to column 23)",
  " (in 'multinom', line 25, column 25 to column 28)",
  " (in 'multinom', line 28, column 11 to column 12)",
  " (in 'multinom', line 28, column 14 to column 17)"};
#include <stan_meta_header.hpp>
class model_multinom final : public model_base_crtp<model_multinom> {
private:
  int n_y;
  int N;
  int p;
  int n_grp;
  Eigen::Matrix<double,-1,-1> X_data__;
  Eigen::Matrix<double,-1,-1> Y_data__;
  Eigen::Matrix<double,1,-1> w_data__;
  std::vector<int> grp;
  int has_int;
  double prior_sigma;
  double prior_sigma_shape;
  double prior_beta;
  double prior_int;
  Eigen::Matrix<double,-1,1> ones_y_data__;
  Eigen::Matrix<double,-1,1> int_col_data__;
  Eigen::Map<Eigen::Matrix<double,-1,-1>> X{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> Y{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,1,-1>> w{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> ones_y{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> int_col{nullptr, 0};
public:
  ~model_multinom() {}
  model_multinom(stan::io::var_context& context__, unsigned int
                 random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_multinom_namespace::model_multinom";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 22;
      context__.validate_dims("data initialization", "n_y", "int",
        std::vector<size_t>{});
      n_y = std::numeric_limits<int>::min();
      current_statement__ = 22;
      n_y = context__.vals_i("n_y")[(1 - 1)];
      current_statement__ = 22;
      stan::math::check_greater_or_equal(function__, "n_y", n_y, 0);
      current_statement__ = 23;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 23;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 23;
      stan::math::check_greater_or_equal(function__, "N", N, 0);
      current_statement__ = 24;
      context__.validate_dims("data initialization", "p", "int",
        std::vector<size_t>{});
      p = std::numeric_limits<int>::min();
      current_statement__ = 24;
      p = context__.vals_i("p")[(1 - 1)];
      current_statement__ = 24;
      stan::math::check_greater_or_equal(function__, "p", p, 0);
      current_statement__ = 25;
      context__.validate_dims("data initialization", "n_grp", "int",
        std::vector<size_t>{});
      n_grp = std::numeric_limits<int>::min();
      current_statement__ = 25;
      n_grp = context__.vals_i("n_grp")[(1 - 1)];
      current_statement__ = 25;
      stan::math::check_greater_or_equal(function__, "n_grp", n_grp, 0);
      current_statement__ = 26;
      stan::math::validate_non_negative_index("X", "N", N);
      current_statement__ = 27;
      stan::math::validate_non_negative_index("X", "p", p);
      current_statement__ = 28;
      context__.validate_dims("data initialization", "X", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(p)});
      X_data__ = Eigen::Matrix<double,-1,-1>::Constant(N, p,
                   std::numeric_limits<double>::quiet_NaN());
      new (&X) Eigen::Map<Eigen::Matrix<double,-1,-1>>(X_data__.data(), N, p);
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 28;
        X_flat__ = context__.vals_r("X");
        current_statement__ = 28;
        pos__ = 1;
        current_statement__ = 28;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 28;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 28;
            stan::model::assign(X, X_flat__[(pos__ - 1)],
              "assigning variable X", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 28;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 29;
      stan::math::validate_non_negative_index("Y", "N", N);
      current_statement__ = 30;
      stan::math::validate_non_negative_index("Y", "n_y", n_y);
      current_statement__ = 31;
      context__.validate_dims("data initialization", "Y", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(n_y)});
      Y_data__ = Eigen::Matrix<double,-1,-1>::Constant(N, n_y,
                   std::numeric_limits<double>::quiet_NaN());
      new (&Y) Eigen::Map<Eigen::Matrix<double,-1,-1>>(Y_data__.data(), N,
        n_y);
      {
        std::vector<local_scalar_t__> Y_flat__;
        current_statement__ = 31;
        Y_flat__ = context__.vals_r("Y");
        current_statement__ = 31;
        pos__ = 1;
        current_statement__ = 31;
        for (int sym1__ = 1; sym1__ <= n_y; ++sym1__) {
          current_statement__ = 31;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 31;
            stan::model::assign(Y, Y_flat__[(pos__ - 1)],
              "assigning variable Y", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 31;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 32;
      stan::math::validate_non_negative_index("w", "N", N);
      current_statement__ = 33;
      context__.validate_dims("data initialization", "w", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      w_data__ = Eigen::Matrix<double,1,-1>::Constant(N,
                   std::numeric_limits<double>::quiet_NaN());
      new (&w) Eigen::Map<Eigen::Matrix<double,1,-1>>(w_data__.data(), N);
      {
        std::vector<local_scalar_t__> w_flat__;
        current_statement__ = 33;
        w_flat__ = context__.vals_r("w");
        current_statement__ = 33;
        pos__ = 1;
        current_statement__ = 33;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 33;
          stan::model::assign(w, w_flat__[(pos__ - 1)],
            "assigning variable w", stan::model::index_uni(sym1__));
          current_statement__ = 33;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 34;
      stan::math::validate_non_negative_index("grp", "N", N);
      current_statement__ = 35;
      context__.validate_dims("data initialization", "grp", "int",
        std::vector<size_t>{static_cast<size_t>(N)});
      grp = std::vector<int>(N, std::numeric_limits<int>::min());
      current_statement__ = 35;
      grp = context__.vals_i("grp");
      current_statement__ = 35;
      stan::math::check_greater_or_equal(function__, "grp", grp, 1);
      current_statement__ = 35;
      stan::math::check_less_or_equal(function__, "grp", grp, n_grp);
      current_statement__ = 36;
      context__.validate_dims("data initialization", "has_int", "int",
        std::vector<size_t>{});
      has_int = std::numeric_limits<int>::min();
      current_statement__ = 36;
      has_int = context__.vals_i("has_int")[(1 - 1)];
      current_statement__ = 36;
      stan::math::check_greater_or_equal(function__, "has_int", has_int, 0);
      current_statement__ = 36;
      stan::math::check_less_or_equal(function__, "has_int", has_int, 1);
      current_statement__ = 37;
      context__.validate_dims("data initialization", "prior_sigma", "double",
        std::vector<size_t>{});
      prior_sigma = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 37;
      prior_sigma = context__.vals_r("prior_sigma")[(1 - 1)];
      current_statement__ = 37;
      stan::math::check_greater_or_equal(function__, "prior_sigma",
        prior_sigma, 0);
      current_statement__ = 38;
      context__.validate_dims("data initialization", "prior_sigma_shape",
        "double", std::vector<size_t>{});
      prior_sigma_shape = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 38;
      prior_sigma_shape = context__.vals_r("prior_sigma_shape")[(1 - 1)];
      current_statement__ = 38;
      stan::math::check_greater_or_equal(function__, "prior_sigma_shape",
        prior_sigma_shape, 1);
      current_statement__ = 39;
      context__.validate_dims("data initialization", "prior_beta", "double",
        std::vector<size_t>{});
      prior_beta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 39;
      prior_beta = context__.vals_r("prior_beta")[(1 - 1)];
      current_statement__ = 39;
      stan::math::check_greater_or_equal(function__, "prior_beta",
        prior_beta, 0);
      current_statement__ = 40;
      context__.validate_dims("data initialization", "prior_int", "double",
        std::vector<size_t>{});
      prior_int = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 40;
      prior_int = context__.vals_r("prior_int")[(1 - 1)];
      current_statement__ = 40;
      stan::math::check_greater_or_equal(function__, "prior_int", prior_int,
        0);
      current_statement__ = 41;
      stan::math::validate_non_negative_index("ones_y", "n_y", n_y);
      current_statement__ = 42;
      ones_y_data__ = Eigen::Matrix<double,-1,1>::Constant(n_y,
                        std::numeric_limits<double>::quiet_NaN());
      new (&ones_y)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(ones_y_data__.data(), n_y);
      current_statement__ = 42;
      stan::model::assign(ones_y, stan::math::rep_vector(1, n_y),
        "assigning variable ones_y");
      current_statement__ = 43;
      stan::math::validate_non_negative_index("int_col", "N", N);
      current_statement__ = 44;
      int_col_data__ = Eigen::Matrix<double,-1,1>::Constant(N,
                         std::numeric_limits<double>::quiet_NaN());
      new (&int_col)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(int_col_data__.data(), N);
      current_statement__ = 44;
      stan::model::assign(int_col, stan::math::rep_vector(has_int, N),
        "assigning variable int_col");
      current_statement__ = 45;
      stan::math::validate_non_negative_index("intercept", "n_y", n_y);
      current_statement__ = 46;
      stan::math::validate_non_negative_index("beta", "p", p);
      current_statement__ = 47;
      stan::math::validate_non_negative_index("beta", "n_y", n_y);
      current_statement__ = 48;
      stan::math::validate_non_negative_index("u", "n_grp", n_grp);
      current_statement__ = 49;
      stan::math::validate_non_negative_index("u", "n_y", n_y);
      current_statement__ = 50;
      stan::math::validate_non_negative_index("sigma_grp", "n_y", n_y);
      current_statement__ = 51;
      stan::math::validate_non_negative_index("L", "n_y", n_y);
      current_statement__ = 51;
      stan::math::validate_non_negative_index("L", "n_y", n_y);
      current_statement__ = 52;
      stan::math::validate_non_negative_index("lsft", "N", N);
      current_statement__ = 53;
      stan::math::validate_non_negative_index("lsft", "n_y", n_y);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = n_y + (p * n_y) + (n_grp * n_y) + n_y + ((n_y * (n_y -
      1)) / 2);
  }
  inline std::string model_name() const final {
    return "model_multinom";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_multinom_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,1,-1> intercept =
        Eigen::Matrix<local_scalar_t__,1,-1>::Constant(n_y, DUMMY_VAR__);
      current_statement__ = 1;
      intercept = in__.template read<
                    Eigen::Matrix<local_scalar_t__,1,-1>>(n_y);
      Eigen::Matrix<local_scalar_t__,-1,-1> beta =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(p, n_y, DUMMY_VAR__);
      current_statement__ = 2;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,-1>>(p,
               n_y);
      Eigen::Matrix<local_scalar_t__,-1,-1> u =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(n_grp, n_y,
          DUMMY_VAR__);
      current_statement__ = 3;
      u = in__.template read<Eigen::Matrix<local_scalar_t__,-1,-1>>(n_grp,
            n_y);
      Eigen::Matrix<local_scalar_t__,-1,1> sigma_grp =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_y, DUMMY_VAR__);
      current_statement__ = 4;
      sigma_grp = in__.template read_constrain_lb<
                    Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0,
                    lp__, n_y);
      Eigen::Matrix<local_scalar_t__,-1,-1> L =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(n_y, n_y,
          DUMMY_VAR__);
      current_statement__ = 5;
      L = in__.template read_constrain_cholesky_factor_corr<
            Eigen::Matrix<local_scalar_t__,-1,-1>, jacobian__>(lp__, n_y);
      Eigen::Matrix<local_scalar_t__,-1,-1> lsft =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(N, n_y, DUMMY_VAR__);
      {
        current_statement__ = 7;
        stan::math::validate_non_negative_index("linpred", "N", N);
        current_statement__ = 8;
        stan::math::validate_non_negative_index("linpred", "n_y", n_y);
        Eigen::Matrix<local_scalar_t__,-1,-1> linpred =
          Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(N, n_y,
            DUMMY_VAR__);
        current_statement__ = 10;
        stan::math::validate_non_negative_index("Sigma", "n_y", n_y);
        current_statement__ = 11;
        stan::math::validate_non_negative_index("Sigma", "n_y", n_y);
        Eigen::Matrix<local_scalar_t__,-1,-1> Sigma =
          Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(n_y, n_y,
            DUMMY_VAR__);
        current_statement__ = 12;
        stan::model::assign(Sigma,
          stan::math::diag_pre_multiply(sigma_grp, L),
          "assigning variable Sigma");
        current_statement__ = 13;
        stan::model::assign(linpred,
          stan::math::add(
            stan::math::add(stan::math::multiply(int_col, intercept),
              stan::math::multiply(X, beta)),
            stan::math::transpose(
              stan::math::multiply(Sigma,
                stan::math::transpose(
                  stan::model::rvalue(u, "u", stan::model::index_multi(grp)))))),
          "assigning variable linpred");
        current_statement__ = 14;
        stan::model::assign(lsft,
          stan::math::subtract(linpred,
            stan::math::rep_matrix(
              stan::math::log(
                stan::math::multiply(stan::math::exp(linpred), ones_y)), n_y)),
          "assigning variable lsft");
      }
      {
        current_statement__ = 16;
        lp_accum__.add(stan::math::sum(
                         stan::math::multiply(w,
                           stan::math::elt_multiply(Y, lsft))));
        current_statement__ = 17;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(intercept, 0,
                         prior_int));
        current_statement__ = 18;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(
                         stan::math::to_vector(beta), 0, prior_beta));
        current_statement__ = 19;
        lp_accum__.add(stan::math::std_normal_lpdf<propto__>(
                         stan::math::to_vector(u)));
        current_statement__ = 20;
        lp_accum__.add(stan::math::inv_gamma_lpdf<propto__>(sigma_grp,
                         prior_sigma_shape, (prior_sigma * (prior_sigma_shape
                         - 1))));
        current_statement__ = 21;
        lp_accum__.add(stan::math::lkj_corr_cholesky_lpdf<propto__>(L, 2.0));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_multinom_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,1,-1> intercept =
        Eigen::Matrix<double,1,-1>::Constant(n_y,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      intercept = in__.template read<
                    Eigen::Matrix<local_scalar_t__,1,-1>>(n_y);
      Eigen::Matrix<double,-1,-1> beta =
        Eigen::Matrix<double,-1,-1>::Constant(p, n_y,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,-1>>(p,
               n_y);
      Eigen::Matrix<double,-1,-1> u =
        Eigen::Matrix<double,-1,-1>::Constant(n_grp, n_y,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 3;
      u = in__.template read<Eigen::Matrix<local_scalar_t__,-1,-1>>(n_grp,
            n_y);
      Eigen::Matrix<double,-1,1> sigma_grp =
        Eigen::Matrix<double,-1,1>::Constant(n_y,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 4;
      sigma_grp = in__.template read_constrain_lb<
                    Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0,
                    lp__, n_y);
      Eigen::Matrix<double,-1,-1> L =
        Eigen::Matrix<double,-1,-1>::Constant(n_y, n_y,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 5;
      L = in__.template read_constrain_cholesky_factor_corr<
            Eigen::Matrix<local_scalar_t__,-1,-1>, jacobian__>(lp__, n_y);
      Eigen::Matrix<double,-1,-1> lsft =
        Eigen::Matrix<double,-1,-1>::Constant(N, n_y,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(intercept);
      out__.write(beta);
      out__.write(u);
      out__.write(sigma_grp);
      out__.write(L);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      {
        current_statement__ = 7;
        stan::math::validate_non_negative_index("linpred", "N", N);
        current_statement__ = 8;
        stan::math::validate_non_negative_index("linpred", "n_y", n_y);
        Eigen::Matrix<double,-1,-1> linpred =
          Eigen::Matrix<double,-1,-1>::Constant(N, n_y,
            std::numeric_limits<double>::quiet_NaN());
        current_statement__ = 10;
        stan::math::validate_non_negative_index("Sigma", "n_y", n_y);
        current_statement__ = 11;
        stan::math::validate_non_negative_index("Sigma", "n_y", n_y);
        Eigen::Matrix<double,-1,-1> Sigma =
          Eigen::Matrix<double,-1,-1>::Constant(n_y, n_y,
            std::numeric_limits<double>::quiet_NaN());
        current_statement__ = 12;
        stan::model::assign(Sigma,
          stan::math::diag_pre_multiply(sigma_grp, L),
          "assigning variable Sigma");
        current_statement__ = 13;
        stan::model::assign(linpred,
          stan::math::add(
            stan::math::add(stan::math::multiply(int_col, intercept),
              stan::math::multiply(X, beta)),
            stan::math::transpose(
              stan::math::multiply(Sigma,
                stan::math::transpose(
                  stan::model::rvalue(u, "u", stan::model::index_multi(grp)))))),
          "assigning variable linpred");
        current_statement__ = 14;
        stan::model::assign(lsft,
          stan::math::subtract(linpred,
            stan::math::rep_matrix(
              stan::math::log(
                stan::math::multiply(stan::math::exp(linpred), ones_y)), n_y)),
          "assigning variable lsft");
      }
      if (emit_transformed_parameters__) {
        out__.write(lsft);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,1,-1> intercept =
        Eigen::Matrix<local_scalar_t__,1,-1>::Constant(n_y, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(intercept,
        in__.read<Eigen::Matrix<local_scalar_t__,1,-1>>(n_y),
        "assigning variable intercept");
      out__.write(intercept);
      Eigen::Matrix<local_scalar_t__,-1,-1> beta =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(p, n_y, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(beta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,-1>>(p, n_y),
        "assigning variable beta");
      out__.write(beta);
      Eigen::Matrix<local_scalar_t__,-1,-1> u =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(n_grp, n_y,
          DUMMY_VAR__);
      current_statement__ = 3;
      stan::model::assign(u,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,-1>>(n_grp, n_y),
        "assigning variable u");
      out__.write(u);
      Eigen::Matrix<local_scalar_t__,-1,1> sigma_grp =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_y, DUMMY_VAR__);
      current_statement__ = 4;
      stan::model::assign(sigma_grp,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(n_y),
        "assigning variable sigma_grp");
      out__.write_free_lb(0, sigma_grp);
      Eigen::Matrix<local_scalar_t__,-1,-1> L =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(n_y, n_y,
          DUMMY_VAR__);
      current_statement__ = 5;
      stan::model::assign(L,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,-1>>(n_y, n_y),
        "assigning variable L");
      out__.write_free_cholesky_factor_corr(L);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "intercept",
        "double", std::vector<size_t>{static_cast<size_t>(n_y)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "beta", "double",
        std::vector<size_t>{static_cast<size_t>(p), static_cast<size_t>(n_y)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "u", "double",
        std::vector<size_t>{static_cast<size_t>(n_grp),
          static_cast<size_t>(n_y)});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "sigma_grp",
        "double", std::vector<size_t>{static_cast<size_t>(n_y)});
      current_statement__ = 5;
      context__.validate_dims("parameter initialization", "L", "double",
        std::vector<size_t>{static_cast<size_t>(n_y),
          static_cast<size_t>(n_y)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,1,-1> intercept =
        Eigen::Matrix<local_scalar_t__,1,-1>::Constant(n_y, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> intercept_flat__;
        current_statement__ = 1;
        intercept_flat__ = context__.vals_r("intercept");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= n_y; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(intercept, intercept_flat__[(pos__ - 1)],
            "assigning variable intercept", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(intercept);
      Eigen::Matrix<local_scalar_t__,-1,-1> beta =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(p, n_y, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 2;
        beta_flat__ = context__.vals_r("beta");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= n_y; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= p; ++sym2__) {
            current_statement__ = 2;
            stan::model::assign(beta, beta_flat__[(pos__ - 1)],
              "assigning variable beta", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 2;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write(beta);
      Eigen::Matrix<local_scalar_t__,-1,-1> u =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(n_grp, n_y,
          DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> u_flat__;
        current_statement__ = 3;
        u_flat__ = context__.vals_r("u");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= n_y; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= n_grp; ++sym2__) {
            current_statement__ = 3;
            stan::model::assign(u, u_flat__[(pos__ - 1)],
              "assigning variable u", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 3;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write(u);
      Eigen::Matrix<local_scalar_t__,-1,1> sigma_grp =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_y, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> sigma_grp_flat__;
        current_statement__ = 4;
        sigma_grp_flat__ = context__.vals_r("sigma_grp");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= n_y; ++sym1__) {
          current_statement__ = 4;
          stan::model::assign(sigma_grp, sigma_grp_flat__[(pos__ - 1)],
            "assigning variable sigma_grp", stan::model::index_uni(sym1__));
          current_statement__ = 4;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_lb(0, sigma_grp);
      Eigen::Matrix<local_scalar_t__,-1,-1> L =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(n_y, n_y,
          DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> L_flat__;
        current_statement__ = 5;
        L_flat__ = context__.vals_r("L");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= n_y; ++sym1__) {
          current_statement__ = 5;
          for (int sym2__ = 1; sym2__ <= n_y; ++sym2__) {
            current_statement__ = 5;
            stan::model::assign(L, L_flat__[(pos__ - 1)],
              "assigning variable L", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 5;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write_free_cholesky_factor_corr(L);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"intercept", "beta", "u", "sigma_grp",
                "L"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"lsft"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(
                                                                    n_y)},
                std::vector<size_t>{static_cast<size_t>(p),
                  static_cast<size_t>(n_y)},
                std::vector<size_t>{static_cast<size_t>(n_grp),
                  static_cast<size_t>(n_y)},
                std::vector<size_t>{static_cast<size_t>(n_y)},
                std::vector<size_t>{static_cast<size_t>(n_y),
                  static_cast<size_t>(n_y)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(N),
               static_cast<size_t>(n_y)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= n_y; ++sym1__) {
      param_names__.emplace_back(std::string() + "intercept" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= n_y; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= p; ++sym2__) {
        param_names__.emplace_back(std::string() + "beta" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= n_y; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= n_grp; ++sym2__) {
        param_names__.emplace_back(std::string() + "u" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= n_y; ++sym1__) {
      param_names__.emplace_back(std::string() + "sigma_grp" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= n_y; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= n_y; ++sym2__) {
        param_names__.emplace_back(std::string() + "L" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n_y; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "lsft" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= n_y; ++sym1__) {
      param_names__.emplace_back(std::string() + "intercept" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= n_y; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= p; ++sym2__) {
        param_names__.emplace_back(std::string() + "beta" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= n_y; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= n_grp; ++sym2__) {
        param_names__.emplace_back(std::string() + "u" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= n_y; ++sym1__) {
      param_names__.emplace_back(std::string() + "sigma_grp" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= ((n_y * (n_y - 1)) / 2); ++sym1__) {
      param_names__.emplace_back(std::string() + "L" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n_y; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "lsft" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
    if (emit_generated_quantities__) {}
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"intercept\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_y) + "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(p) + ",\"cols\":" + std::to_string(n_y) + "},\"block\":\"parameters\"},{\"name\":\"u\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(n_grp) + ",\"cols\":" + std::to_string(n_y) + "},\"block\":\"parameters\"},{\"name\":\"sigma_grp\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_y) + "},\"block\":\"parameters\"},{\"name\":\"L\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(n_y) + ",\"cols\":" + std::to_string(n_y) + "},\"block\":\"parameters\"},{\"name\":\"lsft\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(N) + ",\"cols\":" + std::to_string(n_y) + "},\"block\":\"transformed_parameters\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"intercept\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_y) + "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(p) + ",\"cols\":" + std::to_string(n_y) + "},\"block\":\"parameters\"},{\"name\":\"u\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(n_grp) + ",\"cols\":" + std::to_string(n_y) + "},\"block\":\"parameters\"},{\"name\":\"sigma_grp\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_y) + "},\"block\":\"parameters\"},{\"name\":\"L\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(((n_y * (n_y - 1)) /2)) + "},\"block\":\"parameters\"},{\"name\":\"lsft\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(N) + ",\"cols\":" + std::to_string(n_y) + "},\"block\":\"transformed_parameters\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((n_y + (p * n_y)) + (n_grp * n_y)) + n_y)
      + (n_y * n_y));
    const size_t num_transformed = emit_transformed_parameters * ((N * n_y));
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((n_y + (p * n_y)) + (n_grp * n_y)) + n_y)
      + (n_y * n_y));
    const size_t num_transformed = emit_transformed_parameters * ((N * n_y));
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_multinom_namespace::model_multinom;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_multinom_namespace::profiles__;
}
#endif
#endif
