% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/history_parameter.R
\name{history_mixed_state}
\alias{history_mixed_state}
\title{Extract values of used or fitted history parameter mixed_state}
\usage{
history_mixed_state(
  object,
  summary = TRUE,
  probs = c(0.055, 0.945),
  includePopulationLevel = TRUE
)
}
\arguments{
\item{object}{An object of class \link[=cumhist-class]{cumhist}}

\item{summary}{Whether summary statistics should be returned instead of
raw sample values. Defaults to \code{TRUE}}

\item{probs}{The percentiles used to compute summary, defaults to 89\% credible interval.}

\item{includePopulationLevel}{Logical, for pooled random effect only. Whether to include
population mean as a separate \code{"_population"} level, default to \code{TRUE}.}
}
\value{
A single value, if fixed value was used. A vector or a tibble, depending on the
option used (single intercept, independent or random intercepts), and whether summary was
requested.
}
\description{
A short-cut for \code{history_parameter(object, "mixed_state", ...)}.
}
\examples{
\donttest{
br_fit <- fit_cumhist(br_singleblock, state="State", duration="Duration")
history_tau(br_fit)
}
}
